/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.print.DrJavaBook;
import edu.rice.cs.drjava.model.repl.History;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.text.ConsoleDocument;
import edu.rice.cs.util.text.ConsoleDocumentInterface;
import edu.rice.cs.util.text.EditDocumentException;
import java.awt.print.PageFormat;
import java.io.IOException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionsDocument
extends ConsoleDocument {
    public static final String DEFAULT_PROMPT = "> ";
    public static final String ERROR_STYLE = "error";
    public static final String DEBUGGER_STYLE = "debugger";
    public static final String OBJECT_RETURN_STYLE = "object.return.style";
    public static final String STRING_RETURN_STYLE = "string.return.style";
    public static final String CHARACTER_RETURN_STYLE = "character.return.style";
    public static final String NUMBER_RETURN_STYLE = "number.return.style";
    private final History _history;

    public InteractionsDocument(ConsoleDocumentInterface document) {
        this(document, new History());
    }

    public InteractionsDocument(ConsoleDocumentInterface document, int maxHistorySize) {
        this(document, new History(maxHistorySize));
    }

    public InteractionsDocument(ConsoleDocumentInterface document, History history) {
        super(document);
        this._history = history;
        this._document.setHasPrompt(true);
        this._prompt = DEFAULT_PROMPT;
    }

    public void setInProgress(boolean inProgress) {
        this._document.setHasPrompt(!inProgress);
    }

    public boolean inProgress() {
        return !this._document.hasPrompt();
    }

    public void setBanner(String banner) {
        try {
            this.setPromptPos(0);
            this.insertText(0, banner, OBJECT_RETURN_STYLE);
            this.insertPrompt();
            this._history.moveEnd();
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    public void reset(String banner) {
        try {
            this.setHasPrompt(false);
            this.setPromptPos(0);
            this.removeText(0, this._document.getLength());
            this.insertText(0, banner, OBJECT_RETURN_STYLE);
            this.insertPrompt();
            this._history.moveEnd();
            this.setInProgress(false);
        }
        catch (EditDocumentException e) {
            throw new UnexpectedException(e);
        }
    }

    private void _replaceCurrentLineFromHistory() {
        try {
            this._clearCurrentInputText();
            this.append(this._history.getCurrent(), "default");
        }
        catch (EditDocumentException ble) {
            throw new UnexpectedException(ble);
        }
    }

    public OptionListener<Integer> getHistoryOptionListener() {
        return this._history.getHistoryOptionListener();
    }

    public void addToHistory(String text) {
        this._history.add(text);
    }

    public String removeLastFromHistory() {
        return this._history.removeLast();
    }

    public void saveHistory(FileSaveSelector selector) throws IOException {
        this._history.writeToFile(selector);
    }

    public void saveHistory(FileSaveSelector selector, String editedVersion) throws IOException {
        History.writeToFile(selector, editedVersion);
    }

    public String getHistoryAsStringWithSemicolons() {
        return this._history.getHistoryAsStringWithSemicolons();
    }

    public String getHistoryAsString() {
        return this._history.getHistoryAsString();
    }

    public void clearHistory() {
        this._history.clear();
    }

    public String lastEntry() {
        return this._history.lastEntry();
    }

    public void moveHistoryPrevious(String entry) {
        this._history.movePrevious(entry);
        this._replaceCurrentLineFromHistory();
    }

    public void moveHistoryNext(String entry) {
        this._history.moveNext(entry);
        this._replaceCurrentLineFromHistory();
    }

    private boolean hasHistoryPrevious() {
        return this._history.hasPrevious();
    }

    public boolean hasHistoryNext() {
        return this._history.hasNext();
    }

    public void reverseHistorySearch(String searchString) {
        this._history.reverseSearch(searchString);
        this._replaceCurrentLineFromHistory();
    }

    public void forwardHistorySearch(String searchString) {
        this._history.forwardSearch(searchString);
        this._replaceCurrentLineFromHistory();
    }

    public boolean recallPreviousInteractionInHistory() {
        if (this.hasHistoryPrevious()) {
            this.moveHistoryPrevious(this.getCurrentInteraction());
            return true;
        }
        this._beep.run();
        return false;
    }

    public boolean recallNextInteractionInHistory() {
        if (this.hasHistoryNext()) {
            this.moveHistoryNext(this.getCurrentInteraction());
            return true;
        }
        this._beep.run();
        return false;
    }

    public void reverseSearchInteractionsInHistory() {
        if (this.hasHistoryPrevious()) {
            this.reverseHistorySearch(this.getCurrentInteraction());
        } else {
            this._beep.run();
        }
    }

    public void forwardSearchInteractionsInHistory() {
        if (this.hasHistoryNext()) {
            this.forwardHistorySearch(this.getCurrentInteraction());
        } else {
            this._beep.run();
        }
    }

    public void appendExceptionResult(String message, String styleName) {
        try {
            this.append(new StringBuffer().append(message).append("\n").toString(), styleName);
        }
        catch (EditDocumentException ble) {
            throw new UnexpectedException(ble);
        }
    }

    public void appendSyntaxErrorResult(String message, String interaction, int startRow, int startCol, int endRow, int endCol, String styleName) {
        try {
            int i;
            if (null == message || "null".equals(message)) {
                message = "";
            }
            if (message.indexOf("Lexical error") != -1 && (i = message.lastIndexOf(58)) != -1) {
                message = new StringBuffer().append("Syntax Error:").append(message.substring(i + 2, message.length())).toString();
            }
            if (message.indexOf("Error") == -1) {
                message = new StringBuffer().append("Error: ").append(message).toString();
            }
            this.append(new StringBuffer().append(message).append("\n").toString(), styleName);
        }
        catch (EditDocumentException ble) {
            throw new UnexpectedException(ble);
        }
    }

    public void clearCurrentInteraction() {
        super.clearCurrentInput();
        this._history.moveEnd();
    }

    public String getCurrentInteraction() {
        return this.getCurrentInput();
    }

    @Override
    public String getDefaultStyle() {
        return "default";
    }

    @Override
    public void preparePrintJob() {
        this._book = new DrJavaBook(this.getDocText(0, this.getLength()), "Interactions", new PageFormat());
    }

    protected History getHistory() {
        return this._history;
    }
}

