/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.repl;

import com.rc.retroweaver.runtime.Autobox;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.StringOps;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History
implements OptionConstants,
Serializable {
    public static final String INTERACTION_SEPARATOR = "//End of Interaction//";
    private volatile int _maxSize;
    public static final String HISTORY_FORMAT_VERSION_2 = new StringBuffer().append("// DrJava saved history v2").append(StringOps.EOL).toString();
    private final ArrayList<String> _vector = new ArrayList();
    private volatile int _cursor = -1;
    private final HashMap<Integer, String> _editedEntries = new HashMap();
    private volatile String _currentSearchString = "";
    public final OptionListener<Integer> historyOptionListener = new OptionListener<Integer>(){

        @Override
        public void optionChanged(OptionEvent<Integer> oce) {
            int newSize = (Integer)oce.value;
            History.this.setMaxSize(newSize);
        }

        public String toString() {
            return new StringBuffer().append("HISTORY_MAX_SIZE OptionListener #").append(this.hashCode()).toString();
        }
    };

    public History() {
        this(DrJava.getConfig().getSetting(HISTORY_MAX_SIZE));
        DrJava.getConfig().addOptionListener(HISTORY_MAX_SIZE, this.historyOptionListener);
    }

    public History(int maxSize) {
        if (maxSize < 0) {
            maxSize = 0;
        }
        this._maxSize = maxSize;
    }

    public OptionListener<Integer> getHistoryOptionListener() {
        return this.historyOptionListener;
    }

    public void setEditedEntry(String entry) {
        if (!entry.equals(this.getCurrent())) {
            this._editedEntries.put(Autobox.valueOf(this._cursor), entry);
        }
    }

    public void add(String item) {
        if (item.trim().length() > 0) {
            this._vector.add(item);
            if (this._vector.size() > this._maxSize) {
                this._vector.remove(0);
            }
            this.moveEnd();
            this._editedEntries.clear();
        }
    }

    public String removeLast() {
        if (this._vector.size() == 0) {
            return null;
        }
        String last = this._vector.remove(this._vector.size() - 1);
        if (this._cursor > this._vector.size()) {
            this._cursor = this._vector.size() - 1;
        }
        return last;
    }

    public void moveEnd() {
        this._cursor = this._vector.size();
    }

    public void movePrevious(String entry) {
        if (!this.hasPrevious()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setEditedEntry(entry);
        --this._cursor;
    }

    public String lastEntry() {
        return this._vector.get(this._cursor - 1);
    }

    public void moveNext(String entry) {
        if (!this.hasNext()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.setEditedEntry(entry);
        ++this._cursor;
    }

    public boolean hasNext() {
        return this._cursor < this._vector.size();
    }

    public boolean hasPrevious() {
        return this._cursor > 0;
    }

    public String getCurrent() {
        Integer cursor = Autobox.valueOf(this._cursor);
        if (this._editedEntries.containsKey(cursor)) {
            return this._editedEntries.get(cursor);
        }
        if (this.hasNext()) {
            return this._vector.get(this._cursor);
        }
        return "";
    }

    public int size() {
        return this._vector.size();
    }

    public void clear() {
        this._vector.clear();
    }

    public String getHistoryAsStringWithSemicolons() {
        StringBuffer s = new StringBuffer();
        String delimiter = new StringBuffer().append(INTERACTION_SEPARATOR).append(StringOps.EOL).toString();
        for (int i = 0; i < this._vector.size(); ++i) {
            String nextLine = this._vector.get(i);
            s.append(nextLine);
            s.append(delimiter);
        }
        return s.toString();
    }

    public String getHistoryAsString() {
        StringBuffer sb = new StringBuffer();
        String delimiter = StringOps.EOL;
        for (String s : this._vector) {
            sb.append(s).append(delimiter);
        }
        return sb.toString();
    }

    public void writeToFile(FileSaveSelector selector) throws IOException {
        History.writeToFile(selector, this.getHistoryAsStringWithSemicolons());
    }

    public static void writeToFile(FileSaveSelector selector, final String editedVersion) throws IOException {
        File c;
        try {
            c = selector.getFile();
        }
        catch (OperationCanceledException oce) {
            return;
        }
        if (c != null && (!c.exists() || selector.verifyOverwrite())) {
            FileOps.DefaultFileSaver saver = new FileOps.DefaultFileSaver(c){

                public void saveTo(OutputStream os) throws IOException {
                    OutputStreamWriter osw = new OutputStreamWriter(os);
                    BufferedWriter bw = new BufferedWriter(osw);
                    String file = HISTORY_FORMAT_VERSION_2 + editedVersion;
                    bw.write(file, 0, file.length());
                    bw.close();
                }
            };
            FileOps.saveFile(saver);
        }
    }

    public void setMaxSize(int newSize) {
        if (newSize < 0) {
            newSize = 0;
        }
        if (this.size() > newSize) {
            int numToDelete = this.size() - newSize;
            for (int i = 0; i < numToDelete; ++i) {
                this._vector.remove(0);
            }
            this.moveEnd();
        }
        this._maxSize = newSize;
    }

    public void reverseSearch(String currentInteraction) {
        if (this._currentSearchString.equals("") || !currentInteraction.startsWith(this._currentSearchString)) {
            this._currentSearchString = currentInteraction;
        }
        this.setEditedEntry(currentInteraction);
        while (this.hasPrevious()) {
            this.movePrevious(this.getCurrent());
            if (!this.getCurrent().startsWith(this._currentSearchString, 0)) continue;
        }
        if (!this.getCurrent().startsWith(this._currentSearchString, 0)) {
            this.moveEnd();
        }
    }

    public void forwardSearch(String currentInteraction) {
        if (this._currentSearchString.equals("") || !currentInteraction.startsWith(this._currentSearchString)) {
            this._currentSearchString = currentInteraction;
        }
        this.setEditedEntry(currentInteraction);
        while (this.hasNext()) {
            this.moveNext(this.getCurrent());
            if (!this.getCurrent().startsWith(this._currentSearchString, 0)) continue;
        }
        if (!this.getCurrent().startsWith(this._currentSearchString, 0)) {
            this.moveEnd();
        }
    }
}

