/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.AbstractReducedModel;
import edu.rice.cs.drjava.model.definitions.reducedmodel.Brace;
import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceInfo;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelControl;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;
import edu.rice.cs.drjava.model.definitions.reducedmodel.TokenList;
import java.util.Stack;

public class ReducedModelBrace
extends AbstractReducedModel {
    private ReducedModelControl _parent;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$definitions$reducedmodel$ReducedModelBrace;

    public ReducedModelBrace(ReducedModelControl parent) {
        this._parent = parent;
    }

    public void insertChar(char ch) {
        switch (ch) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                this._insertBrace(String.valueOf(ch));
                break;
            }
            default: {
                this._insertGap(1);
            }
        }
    }

    private void _insertBrace(String text) {
        if (this._cursor.atStart() || this._cursor.atEnd()) {
            this._cursor.insertNewBrace(text);
        } else if (this.current().isGap()) {
            this._cursor.insertBraceToGap(text);
        } else {
            this._cursor.insertNewBrace(text);
        }
    }

    protected void insertGapBetweenMultiCharBrace(int length) {
        throw new RuntimeException("ReducedModelBrace does not keep track of multi-character braces.");
    }

    public void move(int count) {
        this._cursor.move(count);
    }

    public void delete(int count) {
        if (count == 0) {
            return;
        }
        this._cursor.delete(count);
    }

    private boolean _isCurrentBraceMatchable() {
        return ((ReducedToken)this._cursor.current()).isMatchable();
    }

    public boolean isShadowed() {
        return this._parent.isShadowed();
    }

    public int previousBrace() {
        int dist = 0;
        this.resetWalkerLocationToCursor();
        TokenList.Iterator copyCursor = this._cursor.copy();
        if (!copyCursor.atStart()) {
            copyCursor.prev();
        }
        if (copyCursor.atStart()) {
            copyCursor.dispose();
            return -1;
        }
        int relDistance = dist += this._cursor.getBlockOffset();
        while (!copyCursor.atStart()) {
            if (!((ReducedToken)copyCursor.current()).isGap()) {
                if (this.moveWalkerGetState(-relDistance) == FREE) {
                    copyCursor.dispose();
                    return dist + ((ReducedToken)copyCursor.current()).getSize();
                }
                relDistance = 0;
            }
            dist += ((ReducedToken)copyCursor.current()).getSize();
            relDistance += ((ReducedToken)copyCursor.current()).getSize();
            copyCursor.prev();
        }
        copyCursor.dispose();
        return -1;
    }

    public int nextBrace() {
        int offset;
        int relDistance = 0;
        int dist = 0;
        TokenList.Iterator copyCursor = this._cursor.copy();
        this.resetWalkerLocationToCursor();
        if (copyCursor.atStart()) {
            copyCursor.next();
        }
        if ((offset = this.getBlockOffset()) > 0) {
            relDistance = dist = ((ReducedToken)copyCursor.current()).getSize() - offset;
            copyCursor.next();
        }
        while (!copyCursor.atEnd()) {
            if (!((ReducedToken)copyCursor.current()).isGap()) {
                if (this.moveWalkerGetState(relDistance) == FREE) {
                    copyCursor.dispose();
                    return dist;
                }
                relDistance = 0;
            }
            relDistance += ((ReducedToken)copyCursor.current()).getSize();
            dist += ((ReducedToken)copyCursor.current()).getSize();
            copyCursor.next();
        }
        copyCursor.dispose();
        return -1;
    }

    public int balanceForward() {
        this.resetWalkerLocationToCursor();
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter = this._cursor.copy();
        if (!this.openBraceImmediatelyLeft() || this.isShadowed()) {
            iter.dispose();
            return -1;
        }
        iter.prev();
        ReducedToken curToken = (ReducedToken)iter.current();
        if (!$assertionsDisabled && !(curToken instanceof Brace)) {
            throw new AssertionError();
        }
        braceStack.push((Brace)curToken);
        iter.next();
        int relDistance = 0;
        int distance = 0;
        while (!iter.atEnd() && !braceStack.isEmpty()) {
            curToken = (ReducedToken)iter.current();
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                ReducedModelState curBraceState = this.moveWalkerGetState(relDistance);
                relDistance = 0;
                if (curBraceState == FREE && !curToken.isCommentStart()) {
                    if (curBrace.isClosedBrace()) {
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter.dispose();
                            return -1;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
            }
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            iter.next();
        }
        if (!braceStack.isEmpty()) {
            iter.dispose();
            return -1;
        }
        iter.dispose();
        return distance;
    }

    public boolean openBraceImmediatelyLeft() {
        if (this._cursor.atStart() || this._cursor.atFirstItem()) {
            return false;
        }
        int offset = this.getBlockOffset();
        this.prev();
        if (!$assertionsDisabled && offset != this.getBlockOffset()) {
            throw new AssertionError();
        }
        boolean isLeft = this.getBlockOffset() == 0 && this.current().isOpen() && this._isCurrentBraceMatchable();
        this.next();
        return isLeft;
    }

    public boolean closedBraceImmediatelyLeft() {
        if (this._cursor.atStart() || this._cursor.atFirstItem()) {
            return false;
        }
        int offset = this.getBlockOffset();
        this.prev();
        if (!$assertionsDisabled && offset != this.getBlockOffset()) {
            throw new AssertionError();
        }
        boolean isLeft = offset == 0 && this.current().isClosed() && this._isCurrentBraceMatchable();
        this.next();
        return isLeft;
    }

    public int balanceBackward() {
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter = this._cursor.copy();
        this.resetWalkerLocationToCursor();
        if (!this.closedBraceImmediatelyLeft() || this.isShadowed()) {
            iter.dispose();
            return -1;
        }
        int relDistance = 0;
        int distance = 0;
        iter.prev();
        if (!$assertionsDisabled && !(iter.current() instanceof Brace)) {
            throw new AssertionError();
        }
        do {
            ReducedToken curToken = (ReducedToken)iter.current();
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                ReducedModelState curBraceState = this.moveWalkerGetState(-relDistance);
                relDistance = 0;
                if (curBraceState == FREE && !curToken.isCommentStart()) {
                    if (curBrace.isOpenBrace()) {
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter.dispose();
                            return -1;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
            }
            iter.prev();
        } while (!iter.atStart() && !braceStack.isEmpty());
        if (!braceStack.isEmpty()) {
            iter.dispose();
            return -1;
        }
        iter.dispose();
        return distance;
    }

    protected ReducedModelState moveWalkerGetState(int relDistance) {
        return this._parent.moveWalkerGetState(relDistance);
    }

    protected void resetWalkerLocationToCursor() {
        this._parent.resetLocation();
    }

    public BraceInfo _getLineEnclosingBrace() {
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter = this._cursor.copy();
        this.resetWalkerLocationToCursor();
        int distToStart = this._parent.getDistToStart();
        if (distToStart == -1) {
            iter.dispose();
            return BraceInfo.NULL;
        }
        int relDistance = distToStart + 1;
        int distance = 1;
        iter.move(-relDistance);
        int offset = iter.getBlockOffset();
        relDistance += offset;
        distance += offset;
        if (iter.atStart() || iter.atFirstItem()) {
            iter.dispose();
            return BraceInfo.NULL;
        }
        iter.prev();
        while (!iter.atStart()) {
            ReducedToken curToken = (ReducedToken)iter.current();
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                if (this.moveWalkerGetState(-relDistance) == FREE && !curToken.isCommentStart()) {
                    if (curBrace.isOpenBrace()) {
                        if (braceStack.isEmpty()) {
                            String braceType = curBrace.getType();
                            iter.dispose();
                            return new BraceInfo(braceType, distance);
                        }
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter.dispose();
                            return BraceInfo.NULL;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
                relDistance = 0;
            }
            iter.prev();
        }
        iter.dispose();
        return BraceInfo.NULL;
    }

    protected BraceInfo _getEnclosingBrace() {
        int relDistance;
        Stack<Brace> braceStack = new Stack<Brace>();
        TokenList.Iterator iter = this._cursor.copy();
        this.resetWalkerLocationToCursor();
        int distance = relDistance = 0;
        int offset = iter.getBlockOffset();
        relDistance += offset;
        distance += offset;
        if (iter.atStart() || iter.atFirstItem()) {
            iter.dispose();
            return BraceInfo.NULL;
        }
        iter.prev();
        while (!iter.atStart()) {
            ReducedToken curToken = (ReducedToken)iter.current();
            int size = curToken.getSize();
            distance += size;
            relDistance += size;
            if (!curToken.isGap()) {
                Brace curBrace = (Brace)curToken;
                if (this.moveWalkerGetState(-relDistance) == FREE && !curToken.isCommentStart()) {
                    if (curBrace.isOpenBrace()) {
                        if (braceStack.isEmpty()) {
                            String braceType = curBrace.getType();
                            iter.dispose();
                            return new BraceInfo(braceType, distance);
                        }
                        Brace popped = (Brace)braceStack.pop();
                        if (!curBrace.isMatch(popped)) {
                            iter.dispose();
                            return BraceInfo.NULL;
                        }
                    } else {
                        braceStack.push(curBrace);
                    }
                }
                relDistance = 0;
            }
            iter.prev();
        }
        iter.dispose();
        return BraceInfo.NULL;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$model$definitions$reducedmodel$ReducedModelBrace == null ? (class$edu$rice$cs$drjava$model$definitions$reducedmodel$ReducedModelBrace = ReducedModelBrace.class$("edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelBrace")) : class$edu$rice$cs$drjava$model$definitions$reducedmodel$ReducedModelBrace).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

