/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.definitions.reducedmodel;

import edu.rice.cs.drjava.model.definitions.reducedmodel.BraceException;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelState;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedModelStates;
import edu.rice.cs.drjava.model.definitions.reducedmodel.ReducedToken;

class Brace
extends ReducedToken
implements ReducedModelStates {
    public static final String[] braces;
    public static final int BRACES_LENGTH;
    public static final int LAST_BRACE_INDEX;
    public static final int BLK_CMT_BEG_TYPE;
    public static final int BLK_CMT_END_TYPE;
    public static final int EOLN_TYPE;
    public static final int LINE_CMT_TYPE;
    public static final int SINGLE_QUOTE_TYPE;
    public static final int DOUBLE_QUOTE_TYPE;
    public static final int STAR_TYPE;
    public static final int SLASH_TYPE;
    public static final int DOUBLE_ESCAPE_TYPE;
    public static final int ESCAPED_SINGLE_QUOTE_TYPE;
    public static final int ESCAPED_DOUBLE_QUOTE_TYPE;
    private volatile int _type;
    private volatile int _size;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$definitions$reducedmodel$Brace;

    public static Brace MakeBrace(String type, ReducedModelState state) {
        int index = Brace.findBrace(type.intern());
        if (index == BRACES_LENGTH) {
            throw new BraceException("Invalid brace type \"" + type + "\"");
        }
        return new Brace(index, state);
    }

    private Brace(int type, ReducedModelState state) {
        super(state);
        this._type = type;
        this._size = this.getType().length();
    }

    public String getType() {
        return this._type == BRACES_LENGTH ? "!" : braces[this._type];
    }

    public int getSize() {
        return this._size;
    }

    public String toString() {
        StringBuffer val = new StringBuffer("Brace<");
        val.append(this.getType());
        return val.append('>').toString();
    }

    public void flip() {
        if (this.isOpen()) {
            ++this._type;
        } else if (this._type < braces.length - 1) {
            --this._type;
        }
    }

    public boolean isOpen() {
        return this._type % 2 == 0 && this._type < braces.length - 1;
    }

    public boolean isOpenBrace() {
        return this._type == 0 || this._type == 2 || this._type == 4;
    }

    public boolean isClosedBrace() {
        return this._type == 1 || this._type == 3 || this._type == 5;
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public void setType(String type) {
        int index = Brace.findBrace(type = type.intern());
        if (index == braces.length) {
            throw new BraceException("Invalid brace type \"" + type + "\"");
        }
        this._type = index;
        this._size = this.getType().length();
    }

    private static int findBrace(String type) {
        int i;
        if (!$assertionsDisabled && type != type.intern()) {
            throw new AssertionError();
        }
        for (i = 0; i < braces.length && type != braces[i]; ++i) {
        }
        return i;
    }

    public boolean isMatch(Brace other) {
        int off = this.isOpen() ? 1 : -1;
        return this._type + off == other._type;
    }

    public boolean isMatchable() {
        return this._type < BLK_CMT_BEG_TYPE;
    }

    public boolean isDoubleQuote() {
        return this._type == DOUBLE_QUOTE_TYPE;
    }

    public boolean isSingleQuote() {
        return this._type == SINGLE_QUOTE_TYPE;
    }

    public boolean isLineComment() {
        return this._type == LINE_CMT_TYPE;
    }

    public boolean isBlockCommentStart() {
        return this._type == BLK_CMT_BEG_TYPE;
    }

    public boolean isBlockCommentEnd() {
        return this._type == BLK_CMT_END_TYPE;
    }

    public boolean isNewline() {
        return this._type == EOLN_TYPE;
    }

    public boolean isMultipleCharBrace() {
        return this.isLineComment() || this.isBlockCommentStart() || this.isBlockCommentEnd() || this.isDoubleEscapeSequence();
    }

    public boolean isDoubleEscapeSequence() {
        return this.isDoubleEscape() || this.isEscapedDoubleQuote() || this.isEscapedSingleQuote();
    }

    public boolean isDoubleEscape() {
        return this._type == DOUBLE_ESCAPE_TYPE;
    }

    public boolean isEscapedDoubleQuote() {
        return this._type == ESCAPED_DOUBLE_QUOTE_TYPE;
    }

    public boolean isEscapedSingleQuote() {
        return this._type == ESCAPED_SINGLE_QUOTE_TYPE;
    }

    public boolean isGap() {
        return false;
    }

    public boolean isSlash() {
        return this._type == SLASH_TYPE;
    }

    public boolean isStar() {
        return this._type == STAR_TYPE;
    }

    public void grow(int delta) {
        throw new BraceException("Braces can't grow.");
    }

    public void shrink(int delta) {
        throw new BraceException("Braces can't shrink.");
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$model$definitions$reducedmodel$Brace == null ? (class$edu$rice$cs$drjava$model$definitions$reducedmodel$Brace = Brace.class$("edu.rice.cs.drjava.model.definitions.reducedmodel.Brace")) : class$edu$rice$cs$drjava$model$definitions$reducedmodel$Brace).desiredAssertionStatus();
        braces = new String[]{"{", "}", "(", ")", "[", "]", "/*", "*/", "//", "\n", "/", "*", "\"", "\"", "'", "'", "\\\\", "\\", "\\'", "\\\"", ""};
        BRACES_LENGTH = braces.length;
        LAST_BRACE_INDEX = braces.length - 1;
        BLK_CMT_BEG_TYPE = Brace.findBrace("/*");
        BLK_CMT_END_TYPE = Brace.findBrace("*/");
        EOLN_TYPE = Brace.findBrace("\n");
        LINE_CMT_TYPE = Brace.findBrace("//");
        SINGLE_QUOTE_TYPE = Brace.findBrace("'");
        DOUBLE_QUOTE_TYPE = Brace.findBrace("\"");
        STAR_TYPE = Brace.findBrace("*");
        SLASH_TYPE = Brace.findBrace("/");
        DOUBLE_ESCAPE_TYPE = Brace.findBrace("\\\\");
        ESCAPED_SINGLE_QUOTE_TYPE = Brace.findBrace("\\'");
        ESCAPED_DOUBLE_QUOTE_TYPE = Brace.findBrace("\\\"");
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

