/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug.jpda;

import com.rc.retroweaver.runtime.IterableMethods;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VMMismatchException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugEventNotifier;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugListener;
import edu.rice.cs.drjava.model.debug.DebugModelCallback;
import edu.rice.cs.drjava.model.debug.DebugStackData;
import edu.rice.cs.drjava.model.debug.DebugThreadData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.LineNotExecutableException;
import edu.rice.cs.drjava.model.debug.jpda.EventHandlerThread;
import edu.rice.cs.drjava.model.debug.jpda.JPDABreakpoint;
import edu.rice.cs.drjava.model.debug.jpda.JPDAStackData;
import edu.rice.cs.drjava.model.debug.jpda.JPDAThreadData;
import edu.rice.cs.drjava.model.debug.jpda.PendingRequestManager;
import edu.rice.cs.drjava.model.debug.jpda.Step;
import edu.rice.cs.drjava.model.repl.DefaultInteractionsModel;
import edu.rice.cs.drjava.model.repl.DummyInteractionsListener;
import edu.rice.cs.drjava.model.repl.InteractionsListener;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDADebugger
implements Debugger {
    private static final Log _log;
    private static final int OBJECT_COLLECTED_TRIES = 5;
    private static final String ADD_INTERPRETER_SIG = "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Class;[Ljava/lang/Object;[Ljava/lang/String;[Ljava/lang/Class;)V";
    private static final String GET_VARIABLE_SIG = "(Ljava/lang/String;)[Ljava/lang/Object;";
    private static final String NEW_INSTANCE_SIG = "(Ljava/lang/Class;I)Ljava/lang/Object;";
    private volatile GlobalModel _model;
    private volatile VirtualMachine _vm;
    private volatile EventRequestManager _eventManager;
    private final ArrayList<DebugWatchData> _watches = new ArrayList();
    private final PendingRequestManager _pendingRequestManager = new PendingRequestManager(this);
    final DebugEventNotifier _notifier = new DebugEventNotifier();
    private volatile ThreadReference _runningThread;
    private volatile RandomAccessStack _suspendedThreads;
    private volatile ObjectReference _interpreterJVM;
    private volatile InteractionsListener _watchListener;
    private volatile Throwable _eventHandlerError;
    private volatile Runnable _command = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$debug$jpda$JPDADebugger;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$repl$newjvm$InterpreterJVM;

    public JPDADebugger(GlobalModel model) {
        this._model = model;
        this._vm = null;
        this._eventManager = null;
        this._suspendedThreads = new RandomAccessStack(null);
        this._runningThread = null;
        this._interpreterJVM = null;
        this._eventHandlerError = null;
        this._watchListener = new DummyInteractionsListener(){

            public void interactionEnded() {
                JPDADebugger.access$100(JPDADebugger.this);
            }
        };
    }

    private void _log(String message) {
        _log.log(message);
    }

    private void _log(String message, Throwable t) {
        _log.log(message, t);
    }

    @Override
    public void addListener(DebugListener listener) {
        this._notifier.addListener(listener);
        this._model.getBreakpointManager().addListener(listener);
    }

    @Override
    public void removeListener(DebugListener listener) {
        this._notifier.removeListener(listener);
        this._model.getBreakpointManager().removeListener(listener);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public DebugModelCallback callback() {
        return new DebugModelCallback(){};
    }

    @Override
    public boolean isReady() {
        return this._vm != null;
    }

    @Override
    public void startUp() throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.isReady()) {
            this._eventHandlerError = null;
            for (OpenDefinitionsDocument doc : this._model.getOpenDefinitionsDocuments()) {
                doc.checkIfClassFileInSync();
            }
            try {
                this._attachToVM();
            }
            catch (DebugException e1) {
                try {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this._attachToVM();
                    DebugUtil.error.log("Two attempts required for debugger to attach to slave JVM");
                }
                catch (DebugException e2) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this._attachToVM();
                    DebugUtil.error.log("Three attempts required for debugger to attach to slave JVM");
                }
            }
            ThreadDeathRequest tdr = this._eventManager.createThreadDeathRequest();
            tdr.setSuspendPolicy(1);
            tdr.enable();
            EventHandlerThread eventHandler = new EventHandlerThread(this, this._vm);
            eventHandler.start();
            this._model.getInteractionsModel().addListener(this._watchListener);
            ArrayList<Breakpoint> oldBreakpoints = new ArrayList<Breakpoint>(this._model.getBreakpointManager().getRegions());
            this._model.getBreakpointManager().clearRegions();
            for (int i = 0; i < oldBreakpoints.size(); ++i) {
                Breakpoint bp = oldBreakpoints.get(i);
                int lnr = bp.getLineNumber();
                OpenDefinitionsDocument odd = bp.getDocument();
                this.setBreakpoint(new JPDABreakpoint(odd, odd._getOffset(lnr), lnr, bp.isEnabled(), this));
            }
        } else {
            throw new IllegalStateException("Debugger has already been started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.isReady()) {
            Runnable command = new Runnable(){

                public void run() {
                    JPDADebugger.access$300(JPDADebugger.this).getInteractionsModel().removeListener(JPDADebugger.access$200(JPDADebugger.this));
                }
            };
            EventQueue.invokeLater(command);
            this._removeAllDebugInterpreters();
            try {
                this._vm.dispose();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            finally {
                this._model.getInteractionsModel().setToDefaultInterpreter();
                this._vm = null;
                this._suspendedThreads = new RandomAccessStack(null);
                this._eventManager = null;
                this._runningThread = null;
                this._updateWatches();
            }
        }
    }

    @Override
    public void setCurrentThread(DebugThreadData threadData) throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this._ensureReady();
        if (threadData == null) {
            throw new IllegalArgumentException("Cannot set current thread to null.");
        }
        ThreadReference threadRef = this._getThreadFromDebugThreadData(threadData);
        if (this._suspendedThreads.contains(threadRef.uniqueID())) {
            this._suspendedThreads.remove(threadRef.uniqueID());
        }
        if (!threadRef.isSuspended()) {
            throw new IllegalArgumentException("Given thread must be suspended.");
        }
        this._suspendedThreads.push(threadRef);
        try {
            if (threadRef.frameCount() <= 0) {
                this.printMessage(new StringBuffer().append(threadRef.name()).append(" could not be suspended since it has no stackframes.").toString());
                this.resume();
                return;
            }
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebugException(new StringBuffer().append("Could not suspend thread: ").append(e).toString());
        }
        this._switchToInterpreterForThreadReference(threadRef);
        this._switchToSuspendedThread();
        this.printMessage("The current thread has changed.");
    }

    ThreadReference getCurrentThread() {
        return (ThreadReference)this._suspendedThreads.peek();
    }

    @Override
    public boolean hasSuspendedThreads() throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.isReady()) {
            return false;
        }
        return this._suspendedThreads.size() > 0;
    }

    @Override
    public boolean isCurrentThreadSuspended() throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.isReady()) {
            return false;
        }
        return this.hasSuspendedThreads() && !this.hasRunningThread();
    }

    @Override
    public boolean hasRunningThread() throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.isReady()) {
            return false;
        }
        return this._runningThread != null;
    }

    @Override
    public void resume() throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this._ensureReady();
        this._resumeHelper(false);
    }

    @Override
    public void resume(DebugThreadData threadData) throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this._ensureReady();
        ThreadReference thread = this._suspendedThreads.remove(threadData.getUniqueID());
        this._resumeThread(thread, false);
    }

    @Override
    public void step(Debugger.StepType type) throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this._ensureReady();
        this._stepHelper(type, true);
    }

    @Override
    public void addWatch(String field) throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        DebugWatchData w = new DebugWatchData(field);
        this._watches.add(w);
        this._updateWatches();
        this._notifier.watchSet(w);
    }

    @Override
    public void removeWatch(String field) throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this._watches.size(); ++i) {
            DebugWatchData watch = this._watches.get(i);
            if (!watch.getName().equals(field)) continue;
            this._watches.remove(i);
            this._notifier.watchRemoved(watch);
        }
    }

    @Override
    public void removeWatch(int index) throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (index < this._watches.size()) {
            DebugWatchData watch = this._watches.get(index);
            this._watches.remove(index);
            this._notifier.watchRemoved(watch);
        }
    }

    @Override
    public void removeAllWatches() throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        while (this._watches.size() > 0) {
            this.removeWatch(this._watches.get(0).getName());
        }
    }

    public void notifyBreakpointChange(Breakpoint breakpoint) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this._model.getBreakpointManager().changeRegion(breakpoint, new Lambda<Breakpoint, Object>(){

            @Override
            public Object value(Breakpoint bp) {
                return null;
            }

            @Override
            public Object value(Object x0) {
                return this.value((Breakpoint)x0);
            }
        });
    }

    @Override
    public boolean toggleBreakpoint(OpenDefinitionsDocument doc, int offset, int lineNum, boolean isEnabled) throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if ((offset = doc._getLineStartPos(offset)) < 0) {
            return false;
        }
        Breakpoint breakpoint = this._model.getBreakpointManager().getRegionAt(doc, offset);
        if (breakpoint == null) {
            if (offset == doc._getLineEndPos(offset)) {
                Utilities.show("Cannot set a breakpoint on an empty line.");
                return false;
            }
            try {
                this.setBreakpoint(new JPDABreakpoint(doc, offset, lineNum, isEnabled, this));
                return true;
            }
            catch (LineNotExecutableException lne) {
                Utilities.show(lne.getMessage());
                return false;
            }
        }
        this._model.getBreakpointManager().removeRegion(breakpoint);
        return false;
    }

    @Override
    public void setBreakpoint(Breakpoint breakpoint) throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        breakpoint.getDocument().checkIfClassFileInSync();
        this._model.getBreakpointManager().addRegion(breakpoint);
    }

    @Override
    public void removeBreakpoint(Breakpoint bp) throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!(bp instanceof JPDABreakpoint)) {
            throw new IllegalArgumentException("Unsupported breakpoint");
        }
        JPDABreakpoint breakpoint = (JPDABreakpoint)bp;
        Vector requests = breakpoint.getRequests();
        if (requests.size() > 0 && this._eventManager != null) {
            try {
                for (int i = 0; i < requests.size(); ++i) {
                    this._eventManager.deleteEventRequest((EventRequest)requests.get(i));
                }
            }
            catch (VMMismatchException vme) {
                this._log("VMMismatch when removing breakpoint.", vme);
            }
            catch (VMDisconnectedException vmde) {
                this._log("VMDisconnected when removing breakpoint.", vmde);
            }
        }
        this._pendingRequestManager.removePendingRequest(breakpoint);
    }

    @Override
    public ArrayList<DebugWatchData> getWatches() throws DebugException {
        return this._watches;
    }

    @Override
    public ArrayList<DebugThreadData> getCurrentThreadData() throws DebugException {
        List<ThreadReference> listThreads;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.isReady()) {
            return new ArrayList<DebugThreadData>();
        }
        try {
            listThreads = this._vm.allThreads();
        }
        catch (VMDisconnectedException vmde) {
            return new ArrayList<DebugThreadData>();
        }
        ArrayList<DebugThreadData> threads = new ArrayList<DebugThreadData>();
        Iterator i$ = IterableMethods.iterator(listThreads);
        while (i$.hasNext()) {
            ThreadReference ref = (ThreadReference)i$.next();
            try {
                threads.add(new JPDAThreadData(ref));
            }
            catch (ObjectCollectedException e) {}
        }
        return threads;
    }

    @Override
    public ArrayList<DebugStackData> getCurrentStackFrameData() throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.isReady()) {
            return new ArrayList<DebugStackData>();
        }
        if (this._runningThread != null || this._suspendedThreads.size() <= 0) {
            throw new DebugException("No suspended thread to obtain stack frames.");
        }
        try {
            ThreadReference thread = (ThreadReference)this._suspendedThreads.peek();
            ArrayList<DebugStackData> frames = new ArrayList<DebugStackData>();
            for (StackFrame f : thread.frames()) {
                frames.add(new JPDAStackData(f));
            }
            return frames;
        }
        catch (IncompatibleThreadStateException itse) {
            DebugUtil.error.log("Unable to obtain stack frame.", itse);
            return new ArrayList<DebugStackData>();
        }
        catch (VMDisconnectedException vmde) {
            DebugUtil.error.log("VMDisconnected when getting the current stack frame data.", vmde);
            return new ArrayList<DebugStackData>();
        }
        catch (InvalidStackFrameException isfe) {
            DebugUtil.error.log("The stack frame requested is invalid.", isfe);
            return new ArrayList<DebugStackData>();
        }
    }

    public OpenDefinitionsDocument preloadDocument(Location location) {
        String fileName;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        OpenDefinitionsDocument doc = null;
        ReferenceType rt = location.declaringType();
        try {
            fileName = new StringBuffer().append(JPDADebugger.getPackageDir(rt.name())).append(rt.sourceName()).toString();
        }
        catch (AbsentInformationException aie) {
            String className = rt.name().replace('.', File.separatorChar);
            int indexOfDollar = className.indexOf(36);
            if (indexOfDollar > -1) {
                className = className.substring(0, indexOfDollar);
            }
            fileName = new StringBuffer().append(className).append(".java").toString();
        }
        File f = this._model.getSourceFile(fileName);
        if (f != null) {
            try {
                doc = this._model.getDocumentForFile(f);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return doc;
    }

    @Override
    public void scrollToSource(DebugStackData stackData) throws DebugException {
        Iterator<StackFrame> i;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this._ensureReady();
        if (this._runningThread != null) {
            throw new DebugException("Cannot scroll to source unless thread is suspended.");
        }
        ThreadReference threadRef = (ThreadReference)this._suspendedThreads.peek();
        try {
            if (threadRef.frameCount() <= 0) {
                this.printMessage("Could not scroll to source. The current thread had no stack frames.");
                return;
            }
            i = threadRef.frames().iterator();
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebugException(new StringBuffer().append("Unable to find stack frames: ").append(e).toString());
        }
        while (i.hasNext()) {
            StackFrame frame = i.next();
            if (frame.location().lineNumber() != stackData.getLine() || !stackData.getMethod().equals(new StringBuffer().append(frame.location().declaringType().name()).append(".").append(frame.location().method().name()).toString())) continue;
            this.scrollToSource(frame.location(), false);
        }
    }

    @Override
    public void scrollToSource(Breakpoint bp) {
        this.openAndScroll(bp.getDocument(), bp.getLineNumber(), bp.getClassName(), false);
    }

    @Override
    public Breakpoint getBreakpoint(int line, String className) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this._model.getBreakpointManager().getRegions().size(); ++i) {
            Breakpoint bp = this._model.getBreakpointManager().getRegions().get(i);
            if (bp.getLineNumber() != line || !bp.getClassName().equals(className)) continue;
            return bp;
        }
        return null;
    }

    VirtualMachine getVM() {
        return this._vm;
    }

    EventRequestManager getEventRequestManager() {
        return this._eventManager;
    }

    PendingRequestManager getPendingRequestManager() {
        return this._pendingRequestManager;
    }

    ThreadReference getThreadAt(int i) {
        return this._suspendedThreads.peekAt(i);
    }

    ThreadReference getCurrentRunningThread() {
        return this._runningThread;
    }

    private void _ensureReady() throws DebugException {
        if (!this.isReady()) {
            throw new IllegalStateException("Debugger is not active.");
        }
        if (this._eventHandlerError != null) {
            Throwable t = this._eventHandlerError;
            this._eventHandlerError = null;
            throw new DebugException(new StringBuffer().append("Error in Debugger Event Handler: ").append(t).toString());
        }
    }

    void eventHandlerError(Throwable t) {
        this._log(new StringBuffer().append("Error in EventHandlerThread: ").append(t).toString());
        this._eventHandlerError = t;
    }

    private void _attachToVM() throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        AttachingConnector connector = this._getAttachingConnector();
        Map<String, Connector.Argument> args = connector.defaultArguments();
        Connector.Argument port = args.get("port");
        Connector.Argument host = args.get("hostname");
        try {
            int debugPort = this._model.getDebugPort();
            port.setValue(new StringBuffer().append("").append(debugPort).toString());
            host.setValue("127.0.0.1");
            this._vm = connector.attach(args);
            this._eventManager = this._vm.eventRequestManager();
        }
        catch (Exception e) {
            throw new DebugException(new StringBuffer().append("Could not connect to VM: ").append(e).toString());
        }
        this._interpreterJVM = (ObjectReference)JPDADebugger._getStaticField(this._getClass((class$edu$rice$cs$drjava$model$repl$newjvm$InterpreterJVM == null ? (class$edu$rice$cs$drjava$model$repl$newjvm$InterpreterJVM = JPDADebugger.class$("edu.rice.cs.drjava.model.repl.newjvm.InterpreterJVM")) : class$edu$rice$cs$drjava$model$repl$newjvm$InterpreterJVM).getName()), "ONLY");
    }

    private AttachingConnector _getAttachingConnector() throws DebugException {
        VirtualMachineManager vmm = Bootstrap.virtualMachineManager();
        List<AttachingConnector> connectors = vmm.attachingConnectors();
        AttachingConnector connector = null;
        for (AttachingConnector conn : connectors) {
            if (!conn.name().equals("com.sun.jdi.SocketAttach")) continue;
            connector = conn;
        }
        if (connector == null) {
            throw new DebugException("Could not find an AttachingConnector!");
        }
        return connector;
    }

    boolean setCurrentThread(ThreadReference thread) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!thread.isSuspended()) {
            throw new IllegalArgumentException(new StringBuffer().append("Thread must be suspended to set as current.  Given: ").append(thread).toString());
        }
        try {
            if ((this._suspendedThreads.isEmpty() || !this._suspendedThreads.contains(thread.uniqueID())) && thread.frameCount() > 0) {
                this._suspendedThreads.push(thread);
                return true;
            }
            return false;
        }
        catch (IncompatibleThreadStateException itse) {
            throw new UnexpectedException(itse);
        }
    }

    Vector<ReferenceType> getReferenceTypes(String className, int lineNumber) {
        List<ReferenceType> classes;
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        try {
            classes = this._vm.classesByName(className);
        }
        catch (VMDisconnectedException vmde) {
            return new Vector<ReferenceType>();
        }
        Vector<ReferenceType> refTypes = new Vector<ReferenceType>();
        for (int i = 0; i < classes.size(); ++i) {
            ReferenceType ref = classes.get(i);
            if (lineNumber != -1) {
                List<Object> lines = new LinkedList();
                try {
                    lines = ref.locationsOfLine(lineNumber);
                }
                catch (AbsentInformationException aie) {
                }
                catch (ClassNotPreparedException cnpe) {
                    continue;
                }
                if (lines.size() == 0) {
                    List<ReferenceType> innerRefs = ref.nestedTypes();
                    ref = null;
                    for (int j = 0; j < innerRefs.size(); ++j) {
                        try {
                            ReferenceType currRef = innerRefs.get(j);
                            lines = currRef.locationsOfLine(lineNumber);
                            if (lines.size() <= 0) continue;
                            ref = currRef;
                            break;
                        }
                        catch (AbsentInformationException aie) {
                            continue;
                        }
                        catch (ClassNotPreparedException cnpe) {
                            // empty catch block
                        }
                    }
                }
            }
            if (ref == null || !ref.isPrepared()) continue;
            refTypes.add(ref);
        }
        return refTypes;
    }

    private ThreadReference _getThreadFromDebugThreadData(DebugThreadData d) throws NoSuchElementException {
        List<ThreadReference> threads = this._vm.allThreads();
        for (ThreadReference threadRef : threads) {
            if (threadRef.uniqueID() != d.getUniqueID()) continue;
            return threadRef;
        }
        throw new NoSuchElementException(new StringBuffer().append("Thread ").append(d.getName()).append(" not found in virtual machine!").toString());
    }

    private void _resumeFromStep() throws DebugException {
        this._resumeHelper(true);
    }

    private void _resumeHelper(boolean fromStep) throws DebugException {
        try {
            ThreadReference thread = (ThreadReference)this._suspendedThreads.pop();
            _log.log("In resumeThread()");
            this._resumeThread(thread, fromStep);
        }
        catch (NoSuchElementException e) {
            throw new DebugException("No thread to resume.");
        }
    }

    private void _resumeThread(ThreadReference thread, boolean fromStep) throws DebugException {
        if (thread == null) {
            throw new IllegalArgumentException("Cannot resume a null thread");
        }
        int suspendCount = thread.suspendCount();
        _log.log(new StringBuffer().append("Getting suspendCount = ").append(suspendCount).toString());
        this._runningThread = thread;
        if (!fromStep) {
            this._copyVariablesFromInterpreter();
            this._updateWatches();
        }
        try {
            this._removeCurrentDebugInterpreter(fromStep);
            this._currThreadResumed();
        }
        catch (DebugException e) {
            throw new UnexpectedException(e);
        }
        for (int i = suspendCount; i > 0; --i) {
            thread.resume();
        }
        if (!fromStep && !this._suspendedThreads.isEmpty()) {
            this._switchToSuspendedThread();
        }
    }

    private void _stepHelper(Debugger.StepType type, boolean shouldNotify) throws DebugException {
        if (this._suspendedThreads.size() <= 0 || this._runningThread != null) {
            throw new IllegalStateException("Cannot step if the current thread is not suspended.");
        }
        _log.log(new StringBuffer().append(this).append("is About to peek ...").toString());
        ThreadReference thread = (ThreadReference)this._suspendedThreads.peek();
        _log.log(new StringBuffer().append(this).append("is Stepping ").append(thread.toString()).toString());
        this._runningThread = thread;
        this._copyVariablesFromInterpreter();
        _log.log(new StringBuffer().append(this).append(" is Deleting pending requests ...").toString());
        List<StepRequest> steps = this._eventManager.stepRequests();
        for (int i = 0; i < steps.size(); ++i) {
            StepRequest step = steps.get(i);
            if (!step.thread().equals(thread)) continue;
            this._eventManager.deleteEventRequest(step);
            break;
        }
        _log.log(new StringBuffer().append(this).append(" Issued step request").toString());
        int stepFlag = Integer.MIN_VALUE;
        switch (type) {
            case STEP_INTO: {
                stepFlag = 1;
                break;
            }
            case STEP_OVER: {
                stepFlag = 2;
                break;
            }
            case STEP_OUT: {
                stepFlag = 3;
            }
        }
        new Step(this, -2, stepFlag);
        if (shouldNotify) {
            this.notifyStepRequested();
        }
        _log.log(new StringBuffer().append(this).append(" About to resume").toString());
        this._resumeFromStep();
    }

    void reachedBreakpoint(BreakpointRequest request) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Object property = request.getProperty("debugAction");
        if (property != null && property instanceof JPDABreakpoint) {
            final JPDABreakpoint breakpoint = (JPDABreakpoint)property;
            this.printMessage(new StringBuffer().append("Breakpoint hit in class ").append(breakpoint.getClassName()).append("  [line ").append(breakpoint.getLineNumber()).append("]").toString());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JPDADebugger.this._notifier.breakpointReached(breakpoint);
                }
            });
        } else {
            DebugUtil.error.log(new StringBuffer().append("Reached a breakpoint without a debugAction property: ").append(request).toString());
        }
    }

    private void scrollToSource(Location location) {
        this.scrollToSource(location, true);
    }

    private void scrollToSource(Location location, boolean shouldHighlight) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        OpenDefinitionsDocument doc = this.preloadDocument(location);
        this.openAndScroll(doc, location, shouldHighlight);
    }

    private void openAndScroll(OpenDefinitionsDocument doc, Location location, boolean shouldHighlight) {
        this.openAndScroll(doc, location.lineNumber(), location.declaringType().name(), shouldHighlight);
    }

    private void openAndScroll(final OpenDefinitionsDocument doc, final int line, String className, final boolean shouldHighlight) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (doc != null) {
            doc.checkIfClassFileInSync();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JPDADebugger.this._notifier.threadLocationUpdated(doc, line, shouldHighlight);
                }
            });
        } else {
            this.printMessage(new StringBuffer().append("  (Source for ").append(className).append(" not found.)").toString());
        }
    }

    static String getPackageDir(String className) {
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, lastDotIndex);
        packageName = packageName.replace('.', File.separatorChar);
        return new StringBuffer().append(packageName).append(File.separatorChar).toString();
    }

    void printMessage(String message) {
        this._model.printDebugMessage(message);
    }

    private void _hideWatches() {
        for (int i = 0; i < this._watches.size(); ++i) {
            DebugWatchData currWatch = this._watches.get(i);
            currWatch.hideValueAndType();
        }
    }

    private void _updateWatches() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!this.isReady()) {
            return;
        }
        for (DebugWatchData w : this._watches) {
            String val = this._model.getInteractionsModel().getVariableToString(w.getName());
            if (val == null) {
                w.setNoValue();
            } else {
                w.setValue(val);
            }
            String type = this._model.getInteractionsModel().getVariableType(w.getName());
            if (type == null) {
                w.setNoType();
                continue;
            }
            w.setType(type);
        }
    }

    private void _dumpVariablesIntoInterpreterAndSwitch() throws DebugException {
        _log.log(new StringBuffer().append(this).append(" invoked dumpVariablesIntoInterpreterAndSwitch").toString());
        LinkedList<ObjectReference> toRelease = new LinkedList<ObjectReference>();
        try {
            ThreadReference thread = (ThreadReference)this._suspendedThreads.peek();
            String interpreterName = this._getUniqueThreadName(thread);
            StringReference mirroredName = this._mirrorString(interpreterName, toRelease);
            ObjectReference thisVal = thread.frame(0).thisObject();
            ClassObjectReference thisClass = thread.frame(0).location().declaringType().classObject();
            LinkedList<ObjectReference> localVars = new LinkedList<ObjectReference>();
            LinkedList<StringReference> localVarNames = new LinkedList<StringReference>();
            LinkedList<ClassObjectReference> localVarClasses = new LinkedList<ClassObjectReference>();
            try {
                for (LocalVariable v : thread.frame(0).visibleVariables()) {
                    try {
                        Type t = v.type();
                        if (t instanceof ReferenceType) {
                            localVarClasses.add(((ReferenceType)t).classObject());
                        } else {
                            localVarClasses.add(null);
                        }
                        localVarNames.add(this._mirrorString(v.name(), toRelease));
                        Value val = thread.frame(0).getValue(v);
                        if (val == null || val instanceof ObjectReference) {
                            localVars.add((ObjectReference)val);
                            continue;
                        }
                        localVars.add(this._box((PrimitiveValue)val, thread, toRelease));
                    }
                    catch (ClassNotLoadedException e) {}
                }
            }
            catch (AbsentInformationException e) {
                // empty catch block
            }
            ArrayReference mirroredVars = this._mirrorArray("java.lang.Object", localVars, thread, toRelease);
            ArrayReference mirroredVarNames = this._mirrorArray("java.lang.String", localVarNames, thread, toRelease);
            ArrayReference mirroredVarClasses = this._mirrorArray("java.lang.Class", localVarClasses, thread, toRelease);
            JPDADebugger._invokeMethod(thread, this._interpreterJVM, "addInterpreter", ADD_INTERPRETER_SIG, mirroredName, thisVal, thisClass, mirroredVars, mirroredVarNames, mirroredVarClasses);
            String prompt = this._getPromptString(thread);
            _log.log(new StringBuffer().append(this).append(" is setting active interpreter").toString());
            this._model.getInteractionsModel().setActiveInterpreter(interpreterName, prompt);
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebugException(e);
        }
        finally {
            for (ObjectReference ref : toRelease) {
                ref.enableCollection();
            }
        }
    }

    private String _getPromptString(ThreadReference threadRef) {
        return new StringBuffer().append("[").append(threadRef.name()).append("] > ").toString();
    }

    private StringReference _mirrorString(String s, List<ObjectReference> toRelease) throws DebugException {
        for (int tries = 0; tries < 5; ++tries) {
            try {
                StringReference result = this._vm.mirrorOf(s);
                result.disableCollection();
                if (result.isCollected()) continue;
                toRelease.add(result);
                return result;
            }
            catch (ObjectCollectedException e) {
                // empty catch block
            }
        }
        throw new DebugException("Ran out of OBJECT_COLLECTED_TRIES");
    }

    private ArrayReference _mirrorArray(String elementClass, List<? extends ObjectReference> elts, ThreadReference thread, List<ObjectReference> toRelease) throws DebugException {
        ClassType arrayC = (ClassType)this._getClass("java.lang.reflect.Array");
        ReferenceType elementC = this._getClass(elementClass);
        for (int tries = 0; tries < 5; ++tries) {
            try {
                ArrayReference result = (ArrayReference)JPDADebugger._invokeStaticMethod(thread, arrayC, "newInstance", NEW_INSTANCE_SIG, elementC.classObject(), this._vm.mirrorOf(elts.size()));
                result.disableCollection();
                if (result.isCollected()) continue;
                toRelease.add(result);
                try {
                    result.setValues(elts);
                }
                catch (InvalidTypeException e) {
                    throw new DebugException(e);
                }
                catch (ClassNotLoadedException e) {
                    throw new DebugException(e);
                }
                return result;
            }
            catch (ObjectCollectedException e) {
                // empty catch block
            }
        }
        throw new DebugException("Ran out of OBJECT_COLLECTED_TRIES");
    }

    private ObjectReference _box(PrimitiveValue val, ThreadReference thread, List<ObjectReference> toRelease) throws DebugException {
        String c = null;
        String prim = null;
        if (val instanceof BooleanValue) {
            c = "java.lang.Boolean";
            prim = "Z";
        } else if (val instanceof IntegerValue) {
            c = "java.lang.Integer";
            prim = "I";
        } else if (val instanceof DoubleValue) {
            c = "java.lang.Double";
            prim = "D";
        } else if (val instanceof CharValue) {
            c = "java.lang.Character";
            prim = "C";
        } else if (val instanceof ByteValue) {
            c = "java.lang.Byte";
            prim = "B";
        } else if (val instanceof ShortValue) {
            c = "java.lang.Short";
            prim = "S";
        } else if (val instanceof LongValue) {
            c = "java.lang.Long";
            prim = "J";
        } else if (val instanceof FloatValue) {
            c = "java.lang.Float";
            prim = "F";
        }
        ClassType location = (ClassType)this._getClass(c);
        for (int tries = 0; tries < 5; ++tries) {
            try {
                ObjectReference result;
                try {
                    String valueOfSig = new StringBuffer().append("(").append(prim).append(")L").append(c.replace('.', '/')).append(";").toString();
                    result = (ObjectReference)JPDADebugger._invokeStaticMethod(thread, location, "valueOf", valueOfSig, val);
                }
                catch (DebugException e) {
                    DebugUtil.debug.log("Can't invoke valueOf()", e);
                    String consSig = new StringBuffer().append("(").append(prim).append(")V").toString();
                    result = (ObjectReference)JPDADebugger._invokeConstructor(thread, location, consSig, val);
                }
                result.disableCollection();
                if (result.isCollected()) continue;
                toRelease.add(result);
                return result;
            }
            catch (ObjectCollectedException e) {
                // empty catch block
            }
        }
        throw new DebugException("Ran out of OBJECT_COLLECTED_TRIES");
    }

    private PrimitiveValue _unbox(ObjectReference val, ThreadReference thread) throws DebugException {
        if (val == null) {
            throw new DebugException("Value can't be unboxed");
        }
        String type = val.referenceType().name();
        String m = null;
        String sig = null;
        if (type.equals("java.lang.Boolean")) {
            m = "booleanValue";
            sig = "()Z";
        } else if (type.equals("java.lang.Integer")) {
            m = "intValue";
            sig = "()I";
        } else if (type.equals("java.lang.Double")) {
            m = "doubleValue";
            sig = "()D";
        } else if (type.equals("java.lang.Character")) {
            m = "charValue";
            sig = "()C";
        } else if (type.equals("java.lang.Byte")) {
            m = "byteValue";
            sig = "()B";
        } else if (type.equals("java.lang.Short")) {
            m = "shortValue";
            sig = "()S";
        } else if (type.equals("java.lang.Long")) {
            m = "longValue";
            sig = "()J";
        } else if (type.equals("java.lang.Float")) {
            m = "floatValue";
            sig = "()F";
        }
        if (m == null) {
            throw new DebugException("Value can't be unboxed");
        }
        return (PrimitiveValue)JPDADebugger._invokeMethod(thread, val, m, sig, new Value[0]);
    }

    private ReferenceType _getClass(String name) throws DebugException {
        List<ReferenceType> classes = this._vm.classesByName(name);
        if (classes.isEmpty()) {
            throw new DebugException(new StringBuffer().append("Class '").append(name).append("' is not loaded").toString());
        }
        for (ReferenceType t : classes) {
            if (t.classLoader() != null) continue;
            return t;
        }
        return classes.get(0);
    }

    void currThreadSuspended() {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        try {
            this._dumpVariablesIntoInterpreterAndSwitch();
            this._switchToSuspendedThread();
        }
        catch (DebugException de) {
            throw new UnexpectedException(de);
        }
    }

    private void _switchToSuspendedThread() throws DebugException {
        this._switchToSuspendedThread(true);
    }

    private void _switchToSuspendedThread(boolean updateWatches) throws DebugException {
        _log.log(new StringBuffer().append(this).append(" executing _switchToSuspendedThread()").toString());
        this._runningThread = null;
        if (updateWatches) {
            this._updateWatches();
        }
        ThreadReference currThread = (ThreadReference)this._suspendedThreads.peek();
        this._notifier.currThreadSuspended();
        this._notifier.currThreadSet(new JPDAThreadData(currThread));
        try {
            if (currThread.frameCount() > 0) {
                this.scrollToSource(currThread.frame(0).location());
            }
        }
        catch (IncompatibleThreadStateException itse) {
            throw new UnexpectedException(itse);
        }
    }

    private String _getUniqueThreadName(ThreadReference thread) {
        return Long.toString(thread.uniqueID());
    }

    private void _copyVariablesFromInterpreter() throws DebugException {
        LinkedList<ObjectReference> toRelease = new LinkedList<ObjectReference>();
        try {
            for (LocalVariable var : this._runningThread.frame(0).visibleVariables()) {
                Value oldVal = this._runningThread.frame(0).getValue(var);
                StringReference name = this._mirrorString(var.name(), toRelease);
                ArrayReference wrappedVal = (ArrayReference)JPDADebugger._invokeMethod(this._runningThread, this._interpreterJVM, "getVariable", GET_VARIABLE_SIG, name);
                if (wrappedVal == null || wrappedVal.length() != 1) continue;
                try {
                    Value val = wrappedVal.getValue(0);
                    if (var.type() instanceof PrimitiveType) {
                        try {
                            val = this._unbox((ObjectReference)val, this._runningThread);
                        }
                        catch (DebugException e) {
                            DebugUtil.error.log("Can't unbox variable", e);
                        }
                    }
                    if (oldVal != null && oldVal.equals(val)) continue;
                    try {
                        this._runningThread.frame(0).setValue(var, val);
                    }
                    catch (InvalidTypeException e) {
                        DebugUtil.error.log("Can't set variable", e);
                    }
                    catch (ClassNotLoadedException e) {
                        DebugUtil.error.log("Can't set variable", e);
                    }
                }
                catch (ClassNotLoadedException e) {}
            }
        }
        catch (AbsentInformationException e) {
            for (ObjectReference ref : toRelease) {
                ref.enableCollection();
            }
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebugException(e);
        }
        finally {
            for (ObjectReference ref : toRelease) {
                ref.enableCollection();
            }
        }
    }

    private void _removeAllDebugInterpreters() {
        String oldInterpreterName;
        DefaultInteractionsModel interactionsModel = this._model.getInteractionsModel();
        if (this._runningThread != null) {
            oldInterpreterName = this._getUniqueThreadName(this._runningThread);
            interactionsModel.removeInterpreter(oldInterpreterName);
        }
        while (!this._suspendedThreads.isEmpty()) {
            ThreadReference threadRef = (ThreadReference)this._suspendedThreads.pop();
            oldInterpreterName = this._getUniqueThreadName(threadRef);
            interactionsModel.removeInterpreter(oldInterpreterName);
        }
    }

    private void _removeCurrentDebugInterpreter(boolean fromStep) {
        DefaultInteractionsModel interactionsModel = this._model.getInteractionsModel();
        if (fromStep || this._suspendedThreads.isEmpty()) {
            interactionsModel.setToDefaultInterpreter();
        } else {
            ThreadReference threadRef = (ThreadReference)this._suspendedThreads.peek();
            this._switchToInterpreterForThreadReference(threadRef);
        }
        String oldInterpreterName = this._getUniqueThreadName(this._runningThread);
        interactionsModel.removeInterpreter(oldInterpreterName);
    }

    private void _currThreadResumed() throws DebugException {
        _log.log(new StringBuffer().append(this).append(" is executing _currThreadResumed()").toString());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.currThreadResumed();
            }
        });
    }

    private void _switchToInterpreterForThreadReference(ThreadReference threadRef) {
        String threadName = this._getUniqueThreadName(threadRef);
        String prompt = this._getPromptString(threadRef);
        this._model.getInteractionsModel().setActiveInterpreter(threadName, prompt);
    }

    void threadStarted() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.threadStarted();
            }
        });
    }

    void currThreadDied() throws DebugException {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this.printMessage("The current thread has finished.");
        this._runningThread = null;
        this._updateWatches();
        if (this._suspendedThreads.size() > 0) {
            ThreadReference thread = (ThreadReference)this._suspendedThreads.peek();
            this._switchToInterpreterForThreadReference(thread);
            try {
                if (thread.frameCount() <= 0) {
                    this.printMessage(new StringBuffer().append("Could not scroll to source for ").append(thread.name()).append(". It has no stackframes.").toString());
                } else {
                    this.scrollToSource(thread.frame(0).location());
                }
            }
            catch (IncompatibleThreadStateException e) {
                throw new UnexpectedException(e);
            }
            this._switchToSuspendedThread();
        }
        this._notifier.currThreadDied();
    }

    void nonCurrThreadDied() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.nonCurrThreadDied();
            }
        });
    }

    void notifyDebuggerShutdown() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.debuggerShutdown();
            }
        });
    }

    void notifyDebuggerStarted() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.debuggerStarted();
            }
        });
    }

    void notifyStepRequested() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                JPDADebugger.this._notifier.stepRequested();
            }
        });
    }

    private static Value _invokeMethod(ThreadReference thread, ObjectReference receiver, String name, String signature, Value ... args) throws DebugException {
        try {
            ClassType c = (ClassType)receiver.referenceType();
            Method m = c.concreteMethodByName(name, signature);
            if (m == null) {
                throw new DebugException(new StringBuffer().append("Cannot find method '").append(name).append("'").toString());
            }
            return receiver.invokeMethod(thread, m, Arrays.asList(args), 1);
        }
        catch (ClassNotPreparedException e) {
            throw new DebugException(e);
        }
        catch (IllegalArgumentException e) {
            throw new DebugException(e);
        }
        catch (ClassNotLoadedException e) {
            throw new DebugException(e);
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebugException(e);
        }
        catch (InvocationException e) {
            throw new DebugException(e);
        }
        catch (InvalidTypeException e) {
            throw new DebugException(e);
        }
    }

    private static Value _invokeStaticMethod(ThreadReference thread, ClassType location, String name, String signature, Value ... args) throws DebugException {
        try {
            Method m = location.concreteMethodByName(name, signature);
            if (m == null) {
                throw new DebugException(new StringBuffer().append("Cannot find method '").append(name).append("'").toString());
            }
            return location.invokeMethod(thread, m, Arrays.asList(args), 1);
        }
        catch (ClassNotPreparedException e) {
            throw new DebugException(e);
        }
        catch (IllegalArgumentException e) {
            throw new DebugException(e);
        }
        catch (ClassNotLoadedException e) {
            throw new DebugException(e);
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebugException(e);
        }
        catch (InvocationException e) {
            throw new DebugException(e);
        }
        catch (InvalidTypeException e) {
            throw new DebugException(e);
        }
    }

    private static Value _invokeConstructor(ThreadReference thread, ClassType location, String signature, Value ... args) throws DebugException {
        try {
            Method m = location.concreteMethodByName("<init>", signature);
            if (m == null) {
                throw new DebugException("Cannot find requested constructor");
            }
            return location.newInstance(thread, m, Arrays.asList(args), 1);
        }
        catch (ClassNotPreparedException e) {
            throw new DebugException(e);
        }
        catch (IllegalArgumentException e) {
            throw new DebugException(e);
        }
        catch (ClassNotLoadedException e) {
            throw new DebugException(e);
        }
        catch (IncompatibleThreadStateException e) {
            throw new DebugException(e);
        }
        catch (InvocationException e) {
            throw new DebugException(e);
        }
        catch (InvalidTypeException e) {
            throw new DebugException(e);
        }
    }

    private static Value _getStaticField(ReferenceType location, String name) throws DebugException {
        try {
            Field f = location.fieldByName(name);
            if (f == null) {
                throw new DebugException(new StringBuffer().append("Cannot find field '").append(name).append("'").toString());
            }
            return location.getValue(f);
        }
        catch (ClassNotPreparedException e) {
            throw new DebugException(e);
        }
    }

    static void access$100(JPDADebugger x0) {
        x0._updateWatches();
    }

    static InteractionsListener access$200(JPDADebugger x0) {
        return x0._watchListener;
    }

    static GlobalModel access$300(JPDADebugger x0) {
        return x0._model;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$model$debug$jpda$JPDADebugger == null ? (class$edu$rice$cs$drjava$model$debug$jpda$JPDADebugger = JPDADebugger.class$("edu.rice.cs.drjava.model.debug.jpda.JPDADebugger")) : class$edu$rice$cs$drjava$model$debug$jpda$JPDADebugger).desiredAssertionStatus();
        _log = new Log("GlobalModel.txt", false);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RandomAccessStack
    extends Stack<ThreadReference> {
        private RandomAccessStack() {
        }

        public ThreadReference peekAt(int i) {
            return (ThreadReference)this.get(i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadReference remove(long id) throws NoSuchElementException {
            RandomAccessStack randomAccessStack = this;
            synchronized (randomAccessStack) {
                for (int i = 0; i < this.size(); ++i) {
                    if (((ThreadReference)this.get(i)).uniqueID() != id) continue;
                    ThreadReference t = (ThreadReference)this.get(i);
                    this.remove(i);
                    return t;
                }
            }
            throw new NoSuchElementException(new StringBuffer().append("Thread ").append(id).append(" not found in debugger suspended threads stack!").toString());
        }

        public synchronized boolean contains(long id) {
            for (int i = 0; i < this.size(); ++i) {
                if (((ThreadReference)this.get(i)).uniqueID() != id) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.empty();
        }

        RandomAccessStack(1 x0) {
            this();
        }
    }
}

