/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.request.BreakpointRequest;
import edu.rice.cs.drjava.model.IDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OrderedDocumentRegion;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.jpda.DocumentDebugAction;
import edu.rice.cs.drjava.model.debug.jpda.JPDADebugger;
import edu.rice.cs.util.UnexpectedException;
import java.awt.EventQueue;
import java.util.List;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPDABreakpoint
extends DocumentDebugAction<BreakpointRequest>
implements Breakpoint {
    private volatile Position _position;
    private volatile Position _startPos;
    private volatile Position _endPos;
    private volatile OpenDefinitionsDocument _doc;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$debug$jpda$JPDABreakpoint;

    public JPDABreakpoint(OpenDefinitionsDocument doc, int offset, int lineNumber, boolean isEnabled, JPDADebugger manager) throws DebugException {
        super(manager, doc, offset);
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        this._doc = doc;
        try {
            this._position = doc.createPosition(offset);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        this._suspendPolicy = 1;
        this._lineNumber = lineNumber;
        this._isEnabled = isEnabled;
        try {
            this._startPos = doc.createPosition(this._doc._getLineStartPos(offset));
            this._endPos = doc.createPosition(this._doc._getLineEndPos(offset));
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        if (this._manager != null && this._manager.isReady()) {
            Vector<ReferenceType> refTypes = this._manager.getReferenceTypes(this._className, this._lineNumber);
            this._initializeRequests(refTypes);
            this.setEnabled(isEnabled);
        }
    }

    @Override
    public String getString() {
        try {
            int start = this._startPos.getOffset();
            int end = this._endPos.getOffset();
            int length = end - start;
            if (length <= 120) {
                return this._doc.getText(start, length);
            }
            StringBuffer sb = new StringBuffer(124);
            sb.append(this._doc.getText(start, 120)).append(" ...");
            return sb.toString();
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
    }

    @Override
    protected void _createRequests(Vector<ReferenceType> refTypes) throws DebugException {
        try {
            for (int i = 0; i < refTypes.size(); ++i) {
                ReferenceType rt = refTypes.get(i);
                if (!rt.isPrepared()) continue;
                List<Location> lines = rt.locationsOfLine(this._lineNumber);
                if (lines.size() == 0) {
                    this.setEnabled(false);
                    throw new DebugException(new StringBuffer().append("Could not find line number: ").append(this._lineNumber).toString());
                }
                Location loc = lines.get(0);
                BreakpointRequest request = this._manager.getEventRequestManager().createBreakpointRequest(loc);
                request.setEnabled(this._isEnabled);
                this._requests.add(request);
            }
        }
        catch (AbsentInformationException aie) {
            throw new DebugException(new StringBuffer().append("Could not find line number: ").append(aie).toString());
        }
    }

    @Override
    public int getStartOffset() {
        return this._startPos.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this._endPos.getOffset();
    }

    @Override
    public int getLineStartOffset() {
        return this._startPos.getOffset();
    }

    @Override
    public int getLineEndOffset() {
        return this._endPos.getOffset();
    }

    @Override
    public void update() {
        try {
            int offset = this._position.getOffset();
            this._startPos = this._doc.createPosition(this._doc._getLineStartPos(offset));
            this._endPos = this._doc.createPosition(this._doc._getLineEndPos(offset));
            this._lineNumber = this._doc.getLineOfOffset(offset);
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getStartOffset() == this.getEndOffset();
    }

    public final boolean equals(Object o) {
        if (o == null || !(o instanceof IDocumentRegion)) {
            return false;
        }
        IDocumentRegion r = (IDocumentRegion)o;
        return this.getDocument() == r.getDocument() && this.getStartOffset() == r.getStartOffset() && this.getEndOffset() == r.getEndOffset();
    }

    @Override
    public int compareTo(OrderedDocumentRegion r) {
        int end2;
        int docRel = this.getDocument().compareTo(r.getDocument());
        if (docRel != 0) {
            return docRel;
        }
        if (!$assertionsDisabled && this.getDocument() != r.getDocument()) {
            throw new AssertionError();
        }
        int end1 = this.getEndOffset();
        int endDiff = end1 - (end2 = r.getEndOffset());
        if (endDiff != 0) {
            return endDiff;
        }
        int start1 = this.getStartOffset();
        int start2 = r.getStartOffset();
        return start1 - start2;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        boolean old = this._isEnabled;
        super.setEnabled(isEnabled);
        try {
            for (BreakpointRequest bpr : this._requests) {
                bpr.setEnabled(isEnabled);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        if (this._isEnabled != old) {
            this._manager.notifyBreakpointChange(this);
        }
    }

    public String toString() {
        String cn = this.getClassName();
        if (this._exactClassName != null) {
            cn = this._exactClassName.replace('$', '.');
        }
        if (this._requests.size() > 0) {
            return new StringBuffer().append("Breakpoint[class: ").append(cn).append(", lineNumber: ").append(this.getLineNumber()).append(", method: ").append(((BreakpointRequest)this._requests.get(0)).location().method()).append(", codeIndex: ").append(((BreakpointRequest)this._requests.get(0)).location().codeIndex()).append(", numRefTypes: ").append(this._requests.size()).append("]").toString();
        }
        return new StringBuffer().append("Breakpoint[class: ").append(cn).append(", lineNumber: ").append(this.getLineNumber()).append("]").toString();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((OrderedDocumentRegion)x0);
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$model$debug$jpda$JPDABreakpoint == null ? (class$edu$rice$cs$drjava$model$debug$jpda$JPDABreakpoint = JPDABreakpoint.class$("edu.rice.cs.drjava.model.debug.jpda.JPDABreakpoint")) : class$edu$rice$cs$drjava$model$debug$jpda$JPDABreakpoint).desiredAssertionStatus();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

