/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.javadoc.DefaultJavadocModel;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.javadoc.NoJavadocAvailable;
import edu.rice.cs.plt.collect.CollectUtil;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.reflect.ReflectException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import java.util.List;

public class JDKToolsLibrary {
    private final JavaVersion.FullVersion _version;
    private final CompilerInterface _compiler;
    private final Debugger _debugger;
    private final JavadocModel _javadoc;
    private static final /* synthetic */ Class class$java$util$List;
    private static final /* synthetic */ Class class$java$lang$String;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$GlobalModel;
    private static final /* synthetic */ Class class$edu$rice$cs$plt$reflect$JavaVersion$FullVersion;

    protected JDKToolsLibrary(JavaVersion.FullVersion version, CompilerInterface compiler, Debugger debugger, JavadocModel javadoc) {
        this._version = version;
        this._compiler = compiler;
        this._debugger = debugger;
        this._javadoc = javadoc;
    }

    public JavaVersion.FullVersion version() {
        return this._version;
    }

    public CompilerInterface compiler() {
        return this._compiler;
    }

    public Debugger debugger() {
        return this._debugger;
    }

    public JavadocModel javadoc() {
        return this._javadoc;
    }

    public boolean isValid() {
        return this._compiler.isAvailable() || this._debugger.isAvailable() || this._javadoc.isAvailable();
    }

    public String toString() {
        return "JDK library " + this._version.versionString();
    }

    protected static String adapterForCompiler(JavaVersion version) {
        switch (1.$SwitchMap$edu$rice$cs$plt$reflect$JavaVersion[version.ordinal()]) {
            case 1: {
                return "edu.rice.cs.drjava.model.compiler.Javac160Compiler";
            }
            case 2: {
                return "edu.rice.cs.drjava.model.compiler.Javac150Compiler";
            }
            case 3: {
                return "edu.rice.cs.drjava.model.compiler.Javac141Compiler";
            }
        }
        return null;
    }

    protected static String adapterForDebugger(JavaVersion version) {
        switch (1.$SwitchMap$edu$rice$cs$plt$reflect$JavaVersion[version.ordinal()]) {
            case 1: {
                return "edu.rice.cs.drjava.model.debug.jpda.JPDADebugger";
            }
            case 2: {
                return "edu.rice.cs.drjava.model.debug.jpda.JPDADebugger";
            }
            case 3: {
                return "edu.rice.cs.drjava.model.debug.jpda.JPDADebugger";
            }
        }
        return null;
    }

    public static JDKToolsLibrary makeFromRuntime(GlobalModel model) {
        JavaVersion.FullVersion version = JavaVersion.CURRENT_FULL;
        CompilerInterface compiler = NoCompilerAvailable.ONLY;
        String compilerAdapter = JDKToolsLibrary.adapterForCompiler(version.majorVersion());
        if (compilerAdapter != null) {
            List bootClassPath = null;
            String bootProp = System.getProperty("sun.boot.class.path");
            if (bootProp != null) {
                bootClassPath = CollectUtil.makeList(IOUtil.parsePath((String)bootProp));
            }
            try {
                Class[] sig = new Class[]{class$edu$rice$cs$plt$reflect$JavaVersion$FullVersion == null ? (class$edu$rice$cs$plt$reflect$JavaVersion$FullVersion = JDKToolsLibrary.class$("edu.rice.cs.plt.reflect.JavaVersion$FullVersion")) : class$edu$rice$cs$plt$reflect$JavaVersion$FullVersion, class$java$lang$String == null ? (class$java$lang$String = JDKToolsLibrary.class$("java.lang.String")) : class$java$lang$String, class$java$util$List == null ? (class$java$util$List = JDKToolsLibrary.class$("java.util.List")) : class$java$util$List};
                Object[] args = new Object[]{version, "the runtime class path", bootClassPath};
                CompilerInterface attempt = (CompilerInterface)ReflectUtil.loadObject(compilerAdapter, sig, args);
                if (attempt.isAvailable()) {
                    compiler = attempt;
                }
            }
            catch (ReflectException e) {
            }
            catch (LinkageError e) {
                // empty catch block
            }
        }
        Debugger debugger = NoDebuggerAvailable.ONLY;
        String debuggerAdapter = JDKToolsLibrary.adapterForDebugger(version.majorVersion());
        if (debuggerAdapter != null) {
            try {
                Debugger attempt = (Debugger)ReflectUtil.loadObject(debuggerAdapter, new Class[]{class$edu$rice$cs$drjava$model$GlobalModel == null ? (class$edu$rice$cs$drjava$model$GlobalModel = JDKToolsLibrary.class$("edu.rice.cs.drjava.model.GlobalModel")) : class$edu$rice$cs$drjava$model$GlobalModel}, new Object[]{model});
                if (attempt.isAvailable()) {
                    debugger = attempt;
                }
            }
            catch (ReflectException e) {
            }
            catch (LinkageError e) {
                // empty catch block
            }
        }
        JavadocModel javadoc = new NoJavadocAvailable(model);
        try {
            Class.forName("com.sun.tools.javadoc.Main");
            javadoc = new DefaultJavadocModel(model, null, (Iterable_)((Object)GlobalModel.RUNTIME_CLASS_PATH));
        }
        catch (ClassNotFoundException e) {
        }
        catch (LinkageError e) {
            // empty catch block
        }
        return new JDKToolsLibrary(version, compiler, debugger, javadoc);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$edu$rice$cs$plt$reflect$JavaVersion;

        static {
            $SwitchMap$edu$rice$cs$plt$reflect$JavaVersion = new int[JavaVersion.values().length];
            try {
                1.$SwitchMap$edu$rice$cs$plt$reflect$JavaVersion[JavaVersion.JAVA_6.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$rice$cs$plt$reflect$JavaVersion[JavaVersion.JAVA_5.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$edu$rice$cs$plt$reflect$JavaVersion[JavaVersion.JAVA_1_4.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

