/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.DummyDocumentRegion;
import edu.rice.cs.drjava.model.EventNotifier;
import edu.rice.cs.drjava.model.FileRegion;
import edu.rice.cs.drjava.model.IDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OrderedDocumentRegion;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcreteRegionManager<R extends OrderedDocumentRegion>
extends EventNotifier<RegionManagerListener<R>>
implements RegionManager<R> {
    private volatile HashMap<OpenDefinitionsDocument, SortedSet<R>> _regions = new HashMap();
    private volatile Set<OpenDefinitionsDocument> _documents = new HashSet<OpenDefinitionsDocument>();
    private static final SortedSet<Object> EMPTY_SET;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$model$ConcreteRegionManager;

    @Override
    public Set<OpenDefinitionsDocument> getDocuments() {
        return this._documents;
    }

    private <T> T emptySet() {
        return (T)EMPTY_SET;
    }

    private <T> T newDocumentRegion(OpenDefinitionsDocument odd, int start, int end) {
        return (T)new DocumentRegion(odd, start, end);
    }

    private SortedSet<R> getHeadSet(R r) {
        SortedSet<R> oddRegions = this._regions.get(r.getDocument());
        if (oddRegions == null || oddRegions.isEmpty()) {
            return (SortedSet)this.emptySet();
        }
        return oddRegions.headSet(r);
    }

    @Override
    public SortedSet<R> getTailSet(R r) {
        SortedSet<R> oddRegions = this._regions.get(r.getDocument());
        if (oddRegions == null || oddRegions.isEmpty()) {
            return (SortedSet)this.emptySet();
        }
        return oddRegions.tailSet(r);
    }

    @Override
    public R getRegionAt(OpenDefinitionsDocument odd, int offset) {
        if (!($assertionsDisabled || Utilities.TEST_MODE || EventQueue.isDispatchThread())) {
            throw new AssertionError();
        }
        SortedSet<OrderedDocumentRegion> tail = this.getTailSet((R)((OrderedDocumentRegion)this.newDocumentRegion(odd, 0, offset + 1)));
        if (tail.size() == 0) {
            return null;
        }
        OrderedDocumentRegion r = tail.first();
        int start = r.getStartOffset();
        int end = r.getEndOffset();
        if (start <= offset) {
            return (R)r;
        }
        return null;
    }

    @Override
    public Pair<R, R> getRegionInterval(OpenDefinitionsDocument odd, int offset) {
        int lineEnd;
        OrderedDocumentRegion r;
        int lineStart;
        if (!($assertionsDisabled || Utilities.TEST_MODE || EventQueue.isDispatchThread())) {
            throw new AssertionError();
        }
        SortedSet<DocumentRegion> tail = this.getTailSet((R)new DocumentRegion(odd, 0, offset - 119));
        if (tail.size() == 0) {
            return null;
        }
        Iterator it = tail.iterator();
        OrderedDocumentRegion first = null;
        OrderedDocumentRegion last = null;
        while (it.hasNext() && (lineStart = (r = (OrderedDocumentRegion)it.next()).getLineStartOffset()) <= offset) {
            lineEnd = r.getLineEndOffset();
            if (lineStart - 1 > offset || lineEnd < offset) continue;
            first = r;
            break;
        }
        if (first == null) {
            return null;
        }
        last = first;
        while (it.hasNext() && (lineStart = (r = (OrderedDocumentRegion)it.next()).getLineStartOffset()) <= offset) {
            lineEnd = r.getLineEndOffset();
            if (lineStart > offset || lineEnd < offset) continue;
            last = r;
        }
        return new Pair<Object, Object>(first, last);
    }

    @Override
    public Collection<R> getRegionsOverlapping(OpenDefinitionsDocument odd, int startOffset, int endOffset) {
        OrderedDocumentRegion r;
        if (!($assertionsDisabled || Utilities.TEST_MODE || EventQueue.isDispatchThread())) {
            throw new AssertionError();
        }
        LinkedList<OrderedDocumentRegion> result = new LinkedList<OrderedDocumentRegion>();
        if (startOffset == endOffset) {
            return result;
        }
        SortedSet<OrderedDocumentRegion> tail = this.getTailSet((R)((OrderedDocumentRegion)this.newDocumentRegion(odd, 0, startOffset + 1)));
        Iterator i$ = tail.iterator();
        while (i$.hasNext() && (r = (OrderedDocumentRegion)i$.next()).getStartOffset() < endOffset) {
            result.add(r);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegion(R region) {
        boolean alreadyPresent;
        OpenDefinitionsDocument odd = region.getDocument();
        SortedSet<R> docRegions = this._regions.get(odd);
        if (docRegions == null) {
            this._documents.add(odd);
            docRegions = new TreeSet<R>();
            this._regions.put(odd, docRegions);
        }
        if (!(alreadyPresent = docRegions.contains(region))) {
            docRegions.add(region);
        }
        if (!$assertionsDisabled && !this._documents.contains(odd)) {
            throw new AssertionError();
        }
        if (!alreadyPresent) {
            this._lock.startRead();
            try {
                for (RegionManagerListener l : this._listeners) {
                    l.regionAdded(region);
                }
            }
            finally {
                this._lock.endRead();
            }
        }
    }

    @Override
    public void removeRegion(R region) {
        OpenDefinitionsDocument doc = region.getDocument();
        SortedSet<R> docRegions = this._regions.get(doc);
        if (docRegions == null) {
            return;
        }
        boolean wasRemoved = docRegions.remove(region);
        if (docRegions.isEmpty()) {
            this._documents.remove(doc);
            this._regions.remove(doc);
        }
        if (wasRemoved) {
            this._notifyRegionRemoved(region);
        }
    }

    @Override
    public void removeRegions(Collection<R> regions) {
        for (OrderedDocumentRegion r : regions) {
            this.removeRegion((R)r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _notifyRegionRemoved(R region) {
        this._lock.startRead();
        try {
            for (RegionManagerListener l : this._listeners) {
                l.regionRemoved(region);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _notifyRegionsRemoved(Collection<R> regions) {
        this._lock.startRead();
        try {
            for (OrderedDocumentRegion r : regions) {
                for (RegionManagerListener l : this._listeners) {
                    l.regionRemoved(r);
                }
            }
        }
        catch (Exception e) {
            DrJavaErrorHandler.record(e);
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void removeRegions(OpenDefinitionsDocument doc) {
        if (!$assertionsDisabled && doc == null) {
            throw new AssertionError();
        }
        boolean found = this._documents.remove(doc);
        if (found) {
            SortedSet<R> regions = this._regions.get(doc);
            while (!regions.isEmpty()) {
                OrderedDocumentRegion r = (OrderedDocumentRegion)regions.first();
                regions.remove(r);
                this._notifyRegionRemoved(r);
            }
        }
    }

    @Override
    public SortedSet<R> getRegions(OpenDefinitionsDocument odd) {
        return this._regions.get(odd);
    }

    @Override
    public ArrayList<R> getRegions() {
        ArrayList regions = new ArrayList();
        for (OpenDefinitionsDocument odd : this._documents) {
            regions.addAll(this._regions.get(odd));
        }
        return regions;
    }

    public ArrayList<FileRegion> getFileRegions() {
        ArrayList<FileRegion> regions = new ArrayList<FileRegion>();
        for (OpenDefinitionsDocument odd : this._documents) {
            File f = odd.getRawFile();
            for (OrderedDocumentRegion r : this._regions.get(odd)) {
                regions.add(new DummyDocumentRegion(f, r.getStartOffset(), r.getEndOffset()));
            }
        }
        return regions;
    }

    @Override
    public boolean contains(R region) {
        for (OpenDefinitionsDocument doc : this._documents) {
            if (!this._regions.get(doc).contains(region)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearRegions() {
        for (OrderedDocumentRegion r : this.getRegions()) {
            this.removeRegion((R)r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeRegion(R region, Lambda<R, Object> cmd) {
        cmd.value(region);
        this._lock.startRead();
        try {
            for (RegionManagerListener l : this._listeners) {
                l.regionChanged(region);
            }
        }
        finally {
            this._lock.endRead();
        }
    }

    @Override
    public void updateLines(R firstRegion, R lastRegion) {
        OrderedDocumentRegion region;
        if (!($assertionsDisabled || Utilities.TEST_MODE || EventQueue.isDispatchThread())) {
            throw new AssertionError();
        }
        SortedSet<R> tail = this.getTailSet(firstRegion);
        if (tail.size() == 0) {
            return;
        }
        OrderedDocumentRegion[] tailRegions = tail.toArray(new OrderedDocumentRegion[0]);
        ArrayList<OrderedDocumentRegion> toBeRemoved = new ArrayList<OrderedDocumentRegion>();
        Iterator i$ = tail.iterator();
        while (i$.hasNext() && (region = (OrderedDocumentRegion)i$.next()).compareTo(lastRegion) <= 0) {
            if (region.getStartOffset() == region.getEndOffset()) {
                toBeRemoved.add(region);
                continue;
            }
            region.update();
        }
        for (OrderedDocumentRegion r : toBeRemoved) {
            this.removeRegion((R)r);
        }
    }

    @Override
    public void removeListener(RegionManagerListener x0) {
        super.removeListener(x0);
    }

    @Override
    public void addListener(RegionManagerListener x0) {
        super.addListener(x0);
    }

    @Override
    public void updateLines(IDocumentRegion x0, IDocumentRegion x1) {
        this.updateLines((R)((OrderedDocumentRegion)x0), (R)((OrderedDocumentRegion)x1));
    }

    @Override
    public SortedSet getTailSet(IDocumentRegion x0) {
        return this.getTailSet((R)((OrderedDocumentRegion)x0));
    }

    @Override
    public void changeRegion(IDocumentRegion x0, Lambda x1) {
        this.changeRegion((OrderedDocumentRegion)x0, x1);
    }

    @Override
    public void removeRegion(IDocumentRegion x0) {
        this.removeRegion((R)((OrderedDocumentRegion)x0));
    }

    @Override
    public void addRegion(IDocumentRegion x0) {
        this.addRegion((R)((OrderedDocumentRegion)x0));
    }

    @Override
    public boolean contains(IDocumentRegion x0) {
        return this.contains((R)((OrderedDocumentRegion)x0));
    }

    @Override
    public IDocumentRegion getRegionAt(OpenDefinitionsDocument x0, int x1) {
        return this.getRegionAt(x0, x1);
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$model$ConcreteRegionManager == null ? (class$edu$rice$cs$drjava$model$ConcreteRegionManager = ConcreteRegionManager.class$("edu.rice.cs.drjava.model.ConcreteRegionManager")) : class$edu$rice$cs$drjava$model$ConcreteRegionManager).desiredAssertionStatus();
        EMPTY_SET = new TreeSet<Object>();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

