/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.FormatStrategy;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionParseException;
import edu.rice.cs.drjava.config.ParseStrategy;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorOption<T>
extends Option<Vector<T>> {
    protected ParseStrategy<T> parser;
    protected FormatStrategy<T> formatter;
    public final String header;
    public final char delim;
    public final String footer;

    private VectorOption(String key, ParseStrategy<T> parser, FormatStrategy<T> formatter, String header, char delim, String footer, Vector<T> def) {
        super(key, def);
        this.parser = parser;
        this.formatter = formatter;
        this.header = header;
        this.delim = delim;
        this.footer = footer;
    }

    public VectorOption(String key, Option<T> strategy, String header, char delim, String footer, Vector<T> def) {
        this(key, strategy, strategy, header, delim, footer, def);
    }

    public VectorOption(String key, Option<T> option, Vector<T> def) {
        this(key, option, option, "[", ',', "]", def);
    }

    @Override
    public Vector<T> parse(String s) {
        s = s.trim();
        Vector<T> res = new Vector<T>();
        if (s.equals("")) {
            return res;
        }
        int startFirstElement = this.header.length();
        int startFooter = s.length() - this.footer.length();
        if (startFooter < startFirstElement || !s.startsWith(this.header) || !s.endsWith(this.footer)) {
            throw new OptionParseException(this.name, s, new StringBuffer().append("Value must start with ").append(this.header).append(" and end ").append("with ").append(this.footer).append(" to be a valid vector.").toString());
        }
        if ((s = s.substring(startFirstElement, startFooter)).equals("")) {
            res.add(this.parser.parse(""));
            return res;
        }
        StreamTokenizer st = new StreamTokenizer(new StringReader(s));
        st.resetSyntax();
        st.wordChars(0, 255);
        st.ordinaryChar(124);
        st.ordinaryChar(this.delim);
        try {
            int n;
            int n2 = st.nextToken();
            int n3 = -4;
            StringBuffer sb = new StringBuffer();
            while (n != -1) {
                int n4;
                if (n == 124) {
                    if (n4 == 124) {
                        sb.append('|');
                        n = -4;
                        n4 = -4;
                    } else {
                        n4 = n;
                    }
                } else if (n == this.delim) {
                    if (n4 == 124) {
                        sb.append(this.delim);
                        n = -4;
                        n4 = -4;
                    } else {
                        res.add(this.parser.parse(sb.toString()));
                        sb.setLength(0);
                        n4 = n;
                    }
                } else {
                    if (n4 == 124) {
                        throw new OptionParseException(this.name, s, new StringBuffer().append("A pipe | was discovered before the token '").append(st.sval).append("'. A pipe is only allowed in front of another pipe ").append("or the delimiter ").append(this.delim).append(".").toString());
                    }
                    sb.append(st.sval);
                    n4 = n;
                }
                n = st.nextToken();
            }
            res.add(this.parser.parse(sb.toString()));
        }
        catch (IOException iOException) {
            throw new OptionParseException(this.name, s, "An IOException occurred while parsing a vector.");
        }
        return res;
    }

    @Override
    public String format(Vector<T> v) {
        String str;
        if (v.size() == 0) {
            return "";
        }
        StringBuffer res = new StringBuffer(this.header);
        int size = v.size();
        int i = 0;
        while (i < size) {
            str = this.formatter.format(v.get(i));
            str = str.replaceAll("\\|", "||");
            str = str.replaceAll(",", "|,");
            res.append(str);
            if (++i >= size) continue;
            res.append(this.delim);
        }
        str = res.append(this.footer).toString();
        return str;
    }

    @Override
    public String format(Object x0) {
        return this.format((Vector)x0);
    }

    @Override
    public Object parse(String x0) {
        return this.parse(x0);
    }
}

