/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import com.rc.retroweaver.runtime.IterableMethods;
import com.rc.retroweaver.runtime.Iterable_;
import edu.rice.cs.drjava.config.FileListProperty;
import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.util.StringOps;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursiveFileListProperty
extends FileListProperty {
    protected String _start;

    public RecursiveFileListProperty(String name, String sep, String dir, String start, String help) {
        super(name, sep, dir, help);
        this._start = start;
        this.resetAttributes();
    }

    @Override
    protected List<File> getList(PropertyMaps pm) {
        FileMaskFilter fFilter = new FileMaskFilter((String)this._attributes.get("filter"));
        FileMaskFilter fDirFilter = new FileMaskFilter((String)this._attributes.get("dirfilter"));
        String start = StringOps.replaceVariables((String)this._attributes.get("dir"), pm, PropertyMaps.GET_CURRENT);
        File fStart = new File(start = StringOps.unescapeFileName(start));
        if (fStart.isDirectory()) {
            fDirFilter.addIncludedFile(fStart);
        }
        Iterable_ it = IOUtil.listFilesRecursively((File)fStart, (FileFilter)fFilter, (FileFilter)fDirFilter);
        ArrayList<File> l = new ArrayList<File>();
        Iterator i$ = IterableMethods.iterator(it);
        while (i$.hasNext()) {
            File f = (File)i$.next();
            l.add(f);
        }
        return l;
    }

    @Override
    public void resetAttributes() {
        this._attributes.clear();
        this._attributes.put("sep", this._sep);
        this._attributes.put("rel", this._dir);
        this._attributes.put("dir", this._start);
        this._attributes.put("filter", "*");
        this._attributes.put("dirfilter", "*");
        this._attributes.put("squote", null);
        this._attributes.put("dquote", null);
    }

    public static class FileMaskFilter
    extends RegexFilter {
        private HashSet<File> _include = new HashSet();
        private HashSet<File> _exclude = new HashSet();

        public FileMaskFilter(String mask) {
            super(TextUtil.regexEscape(mask).replaceAll("\\\\\\*", ".*").replaceAll("\\\\\\?", "."));
        }

        public boolean accept(File pathname) {
            if (this._include.contains(pathname)) {
                return true;
            }
            if (this._exclude.contains(pathname)) {
                return false;
            }
            return super.accept(pathname);
        }

        public void addIncludedFile(File f) {
            this._include.add(f);
        }

        public void removeIncludedFile(File f) {
            this._include.remove(f);
        }

        public void clearIncludedFile() {
            this._include.clear();
        }

        public void addExcludedFile(File f) {
            this._exclude.add(f);
        }

        public void removeExcludedFile(File f) {
            this._exclude.remove(f);
        }

        public void clearExcludedFile() {
            this._exclude.clear();
        }
    }

    public static class RegexFilter
    implements FileFilter {
        protected String _regex;

        public RegexFilter(String regex) {
            this._regex = regex;
        }

        public boolean accept(File pathname) {
            return pathname.getName().matches(this._regex);
        }
    }
}

