/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionParseException;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ForcedChoiceOption
extends Option<String> {
    private Collection<String> _choices;

    public ForcedChoiceOption(String key, String def, Collection<String> choices) {
        super(key, def);
        this._choices = choices;
    }

    public boolean isLegal(String s) {
        return this._choices.contains(s);
    }

    public Iterator<String> getLegalValues() {
        return this._choices.iterator();
    }

    public int getNumValues() {
        return this._choices.size();
    }

    @Override
    public String parse(String s) {
        if (this.isLegal(s)) {
            return s;
        }
        throw new OptionParseException(this.name, s, "Value is not an acceptable choice for this option.");
    }

    @Override
    public String format(String s) {
        return s;
    }

    @Override
    public String format(Object x0) {
        return this.format((String)x0);
    }

    @Override
    public Object parse(String x0) {
        return this.parse(x0);
    }
}

