/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.model.AlreadyOpenException;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.DrJavaErrorWindow;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.SimpleInteractionsWindow;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.OutputStreamRedirector;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.rmi.server.ExportException;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrJavaRoot {
    public static final int FULL_JAVA = 0;
    public static final int ELEMENTARY_LEVEL = 1;
    public static final int INTERMEDIATE_LEVEL = 2;
    public static final int ADVANCED_LEVEL = 3;
    public static final String[] LANGUAGE_LEVEL_EXTENSIONS;
    public static final String TEST_DEBUGGER_CLASS = "com.sun.jdi.Bootstrap";
    public static final String PLASTIC_THEMES_PACKAGE = "com.jgoodies.looks.plastic.theme";
    private static final PrintStream _consoleOut;
    private static final PrintStream _consoleErr;
    private static boolean _attemptingAugmentedClassPath;
    private static SimpleInteractionsWindow _debugConsole;
    private static boolean anyLineNumbersSpecified;
    private static MainFrame _mainFrame;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$edu$rice$cs$drjava$DrJavaRoot;

    public static void main(String[] args) {
        DebugUtil.debug.log("Starting up");
        PlatformFactory.ONLY.beforeUISetup();
        if (!DrJava.handleCommandLineArgs(args)) {
            System.exit(0);
        }
        final String[] filesToOpen = DrJava.getFilesToOpen();
        final int numFiles = filesToOpen.length;
        try {
            String configLAFName = DrJava.getConfig().getSetting(OptionConstants.LOOK_AND_FEEL);
            String currLAFName = UIManager.getLookAndFeel().getClass().getName();
            String failureMessage = "DrJava could not load the configured theme for the Plastic Look and Feel.\nIf you've manually edited your configuration file, try \nremoving the key \"plastic.theme\" and restarting DrJava.\nIn the meantime, the system default Look and Feel will be used.\n";
            String failureTitle = "Theme not found";
            if (Utilities.isPlasticLaf(configLAFName)) {
                String themeName = new StringBuffer().append("com.jgoodies.looks.plastic.theme.").append(DrJava.getConfig().getSetting(OptionConstants.PLASTIC_THEMES)).toString();
                try {
                    PlasticTheme theme = (PlasticTheme)Class.forName(themeName).getConstructor(new Class[0]).newInstance(new Object[0]);
                    PlasticLookAndFeel.setPlasticTheme(theme);
                    PlasticLookAndFeel.setTabStyle("metal");
                    Options.setPopupDropShadowEnabled(true);
                    if (!configLAFName.equals(currLAFName)) {
                        UIManager.setLookAndFeel(configLAFName);
                    }
                }
                catch (NoSuchMethodException nsmex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
                catch (SecurityException sex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
                catch (InstantiationException iex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
                catch (IllegalAccessException iaex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
                catch (IllegalArgumentException iaex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
                catch (InvocationTargetException itex) {
                    JOptionPane.showMessageDialog(null, failureMessage, failureTitle, 0);
                }
            } else if (!configLAFName.equals(currLAFName)) {
                UIManager.setLookAndFeel(configLAFName);
            }
            try {
                _mainFrame = new MainFrame();
            }
            catch (RuntimeException e) {
                Throwable c = e.getCause();
                if (c instanceof ExportException && c.getMessage().equals("Listen failed on port: 0")) {
                    JOptionPane.showMessageDialog(null, "DrJava could not communicate with its Interactions Pane.\nThis can happen if a firewall does not allow DrJava to access\nthe network. If you have a firewall, please make sure that\nDrJava has network access.\nDrJava does not access the internet or other computers, except\nfor \"Open Java API Javadoc\", but it needs network access to\ncommunicate with the Interactions Pane.", "Network Access Failed", 0);
                    System.exit(1);
                }
                throw e;
            }
            DrJavaErrorWindow.setFrame(_mainFrame);
            System.setProperty("sun.awt.exception.handler", "edu.rice.cs.drjava.ui.DrJavaErrorHandler");
            DrJavaRoot._openCommandLineFiles(_mainFrame, filesToOpen, numFiles, false);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    DrJavaRoot.access$000().start();
                    if (DrJavaRoot.access$100()) {
                        DrJavaRoot.access$200(DrJavaRoot.access$000(), filesToOpen, numFiles, true);
                    }
                }
            });
            System.setOut(new PrintStream(new OutputStreamRedirector(){

                public void print(String s) {
                    DrJavaRoot.access$000().getModel().systemOutPrint(s);
                }
            }));
            System.setErr(new PrintStream(new OutputStreamRedirector(){

                public void print(String s) {
                    DrJavaRoot.access$000().getModel().systemErrPrint(s);
                }
            }));
            if (DrJava.getShowDebugConsole()) {
                DrJavaRoot.showDrJavaDebugConsole(_mainFrame);
            }
        }
        catch (Throwable t) {
            _consoleErr.println(new StringBuffer().append(t.getClass().getName()).append(": ").append(t.getMessage()).toString());
            t.printStackTrace(_consoleErr);
            System.out.println("error thrown");
            new DrJavaErrorHandler().handle(t);
        }
    }

    static void openCommandLineFiles(MainFrame mf, String[] filesToOpen, boolean jump) {
        DrJavaRoot.openCommandLineFiles(mf, filesToOpen, filesToOpen.length, jump);
    }

    static void openCommandLineFiles(final MainFrame mf, final String[] filesToOpen, final int len, final boolean jump) {
        Utilities.invokeAndWait(new Runnable(){

            public void run() {
                DrJavaRoot.access$200(mf, filesToOpen, len, jump);
            }
        });
    }

    private static void _openCommandLineFiles(MainFrame mf, String[] filesToOpen, int len, boolean jump) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        anyLineNumbersSpecified = false;
        for (int i = 0; i < len; ++i) {
            String currFileName = filesToOpen[i];
            int lineNo = -1;
            int pathSepIndex = currFileName.indexOf(File.pathSeparatorChar);
            if (pathSepIndex >= 0) {
                try {
                    lineNo = Integer.valueOf(currFileName.substring(pathSepIndex + 1));
                    anyLineNumbersSpecified = true;
                }
                catch (NumberFormatException nfe) {
                    lineNo = -1;
                }
                currFileName = currFileName.substring(0, pathSepIndex);
            }
            boolean isProjectFile = currFileName.endsWith(".xml") || currFileName.endsWith(".pjt");
            final File file = new File(currFileName).getAbsoluteFile();
            FileOpenSelector command = new FileOpenSelector(){

                public File[] getFiles() {
                    return new File[]{file};
                }
            };
            try {
                if (isProjectFile) {
                    mf.openProject(command);
                    continue;
                }
                if (currFileName.endsWith(".djapp")) {
                    MainFrame.openExtProcessFile(file);
                    continue;
                }
                if (jump && lineNo >= 0) {
                    mf.open(command);
                    mf._jumpToLine(lineNo);
                    continue;
                }
                mf.getModel().openFile(command);
                continue;
            }
            catch (FileNotFoundException ex) {
                continue;
            }
            catch (SecurityException se) {
                continue;
            }
            catch (AlreadyOpenException aoe) {
                continue;
            }
            catch (FileMovedException aoe) {
                continue;
            }
            catch (IOException ex) {
                continue;
            }
            catch (Exception ex) {
                throw new UnexpectedException(ex);
            }
        }
    }

    public static void showDrJavaDebugConsole(MainFrame mf) {
        if (_debugConsole == null) {
            _debugConsole = new SimpleInteractionsWindow("DrJava Debug Console"){

                protected void close() {
                    this.dispose();
                    DrJavaRoot.access$302(null);
                }
            };
            _debugConsole.setInterpreterPrivateAccessible(true);
            _debugConsole.setVisible(true);
        } else {
            _debugConsole.toFront();
        }
    }

    public static PrintStream consoleErr() {
        return _consoleErr;
    }

    public static PrintStream consoleOut() {
        return _consoleOut;
    }

    public static void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        _mainFrame.dragEnter(dropTargetDragEvent);
    }

    public static void drop(DropTargetDropEvent dropTargetDropEvent) {
        _mainFrame.drop(dropTargetDropEvent);
    }

    public static void installModalWindowAdapter(Window w, Runnable1<? super WindowEvent> toFrontAction, Runnable1<? super WindowEvent> closeAction) {
        _mainFrame.installModalWindowAdapter(w, toFrontAction, closeAction);
    }

    public static void removeModalWindowAdapter(Window w) {
        _mainFrame.removeModalWindowAdapter(w);
    }

    static MainFrame access$000() {
        return _mainFrame;
    }

    static boolean access$100() {
        return anyLineNumbersSpecified;
    }

    static void access$200(MainFrame x0, String[] x1, int x2, boolean x3) {
        DrJavaRoot._openCommandLineFiles(x0, x1, x2, x3);
    }

    static SimpleInteractionsWindow access$302(SimpleInteractionsWindow x0) {
        _debugConsole = x0;
        return _debugConsole;
    }

    static {
        $assertionsDisabled = !(class$edu$rice$cs$drjava$DrJavaRoot == null ? (class$edu$rice$cs$drjava$DrJavaRoot = DrJavaRoot.class$("edu.rice.cs.drjava.DrJavaRoot")) : class$edu$rice$cs$drjava$DrJavaRoot).desiredAssertionStatus();
        LANGUAGE_LEVEL_EXTENSIONS = new String[]{"java", "dj0", "dj1", "dj2"};
        _consoleOut = System.out;
        _consoleErr = System.err;
        _attemptingAugmentedClassPath = false;
        _debugConsole = null;
        anyLineNumbersSpecified = false;
        _mainFrame = null;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(classNotFoundException.getMessage());
            try {
                noClassDefFoundError.initCause(classNotFoundException);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            throw noClassDefFoundError;
        }
        return clazz;
    }
}

