import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.Image;
import java.util.*;
import java.net.*;
import java.io.*;

/** An instance oversees a game. Assignment A7 Quizit CS1110, Spring 2009. */
public class Quizit extends JApplet {
    private boolean isApplet= false; // true: this was started in an applet from a web page
                                     // false: this was started from method main
    
    /** The GUI that is used with this instance of Quizit. */
    private A7GUI gui;
    
    /** The contents of the input file. */
    private Vector<String> inputFile;
    
    /** The dictionary of items for the current topic. */
    private Vector<Item> items;
    
    
    /** Constructor: an instance with not much. Everything will be initialized in
        procedure main, if the program is started using Quizit.main(null); , or in
        procedure init, if this program is started as an applet from a web page. */
    public Quizit() {
    }
    
    /** = "this instance was started as an applet and not using method main */
    public boolean isApplet() {
        return isApplet;
    }
    
    /** Play a game. */
    public static void main(String[] pars) {
        Quizit a= new Quizit();
        a.isApplet= false;
        
        BufferedReader br= null;
        try {
            br= new BufferedReader(new FileReader(new File("topics.txt")));
        } catch (FileNotFoundException e) {
            throw new Error("Topics File not found");
        }
        
        a.readTopicsFile(br);
        
        a.gui= new A7GUI(a.fillItems(), a);
    }
    
    /** initialize the applet */
    public void init() {
        isApplet= true;
        
        InputStream topiclistIS= Quizit.class.getResourceAsStream("topics.txt");
        BufferedReader br= new BufferedReader(new InputStreamReader(topiclistIS));
        
        readTopicsFile(br);
        Vector<String> vs= fillItems();
        gui= new A7GUI(vs, this);
    }
    
    /** Read br into Vector inputFile.
        Precondition: the file being read is a valid topics file */
    public void readTopicsFile(BufferedReader br) {
        inputFile= new Vector<String>();
        try {
            String line= br.readLine();
            // invariant: line contains the last line read.
            //            inputFile contains all lines read in except for line line
            while (line != null) {
                inputFile.add(line);
                line= br.readLine();
            }
            
            br.close();
        } catch (IOException e) {
            throw new Error("IO exception while reading from topics file.");
        }
    }
    
    /** = a list of topics, constructed from field inputFile.*/
    public Vector<String> fillItems() {
        Vector<String> v= new Vector<String>(); 
        // fill v with the list of topics
        
        return v;
    }
    
    /** Process a request to play topic s. */
    public void startTopic(String s) {
        /** The body of this procedure has to do everything needed so that the topic named
            s appears in the GUI, with the right image, the right list of number-labels,
            and the right list of terms. Remember, the drop-down list of numbers should be
            in numerical order and the drop-down list of terms should be in alphabetical order.
            
            It probaby should start by emptying the drop-down number and terms lists in the GUI.
            
            At should make up the dictionary (which will be in field items); to do this, it will
            have to find the lines for this topic in field inputFile.
            
            This task is perhaps the most complicated of all, and you should write several
            extra functions to help out.
       */
    }
    
    /** = the index in inputFile of the line that begins with "topics. s" (-1 if none). */
    public int getTopic(String s) {
    
        return -1;
    }
    
    /** Process a request to associate term s with label n. */
    public void associateTerm(String s, int n) {
 
    }
    
    /** Obtain a file name (from the user) that contains an input topics file.  */
    public static File getTopicsFile( ) {
        JFileChooser jd= new JFileChooser("/Volumes/Work15A/CS1110Fall2008/assignments/a7/");
        jd.setDialogTitle("Choose input file");
        jd.showOpenDialog(null);
        return jd.getSelectedFile();
    }
    
    /** Draw the lines and labels given by items using graphics g. */
    public void drawLinesLabels(Graphics g) {
        // Make sure you handle the case items = null, which indicates that no topic has
        // ever been chosen.
        
    }
     
    
}