import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.Image;

/** An instance is a Panel that contains the image, labels, etc. for the QUIZIT game. */
public class A7Panel extends JPanel {
    private A7GUI gui; // The JFrame on which this panel is placed.
    
    private int width= 28;  // width of panel
    private int height= 23; // height of panel
    private Image im; // the image in this panel
   
    /** Constructor: A JPanel with image im. */
    public A7Panel(Image im, A7GUI gui) {
        this.im= im;
        this.gui= gui;
        if (im == null)
            return;
        int width= im.getWidth(this);
        int height= im.getHeight(this);
        Dimension dim= new Dimension(width, height);
        setSize(dim);
        setPreferredSize(dim);
    }
    
    /** Paint the square, using Graphics g.
        This will call A7.drawLinesLabels in order to draw the lines and numbers and terms. */
       public void paint (Graphics g) {
           Color save= g.getColor(); // Save the color, to be reset at end.
           g.drawImage(im, 0, 0, this);
           gui.getQ().drawLinesLabels(g);
           
           g.setColor(save);
       }
}