import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.Image;
import java.util.*;
import java.net.*;


/** An instance is a GUI for assignment A7. Quizit of CS1110, Spring 2009. */
public class A7GUI extends JFrame {
    private Quizit thisQ;  // The instance of Quizit that created this instance of A7GUI.
    
    private JList topicsJList; // The list of topics.
    
    /** The list of numbers and associate terms to guess. if not empty, one is always selected. */
    private JComboBox jNumbers= new JComboBox();
    private JComboBox jTerms= new JComboBox();
    
    private JPanel jpanel= new JPanel(); // The panel that contains the image.

    private JButton OKButton= new JButton("OK"); // Button to click when user has chosen a term.
    private JButton topicButton= new JButton("topic"); // Button to click when user has chosen a topic.
   
    ButtonListener buttonListener= new ButtonListener(); // Instance for listening to buttons.
    
    /** Constructor: An instance with list t of topics and empty lists of numbers
                     and terms, called from thisA7.  */
    public A7GUI(Vector<String> t, Quizit thisQ) {
        this.thisQ= thisQ;
        setUp(t);
        pack();
        setVisible(true);
    }
    
    /** = the Quizit instance that set up this JFrame. */
    public Quizit getQ() {
        return thisQ;
    }
    
    /** Set up the GUI with list of topics tList and empty number-term lists.
        Precondition: the three lists are not null (they may be empty). */
    private void setUp(Vector<String> tList) {
        Container cp= getContentPane();
        
        // Create the jpanel and add it to this JFrame.
        jpanel= new A7Panel(null, this);
        cp.add(jpanel, BorderLayout.CENTER);

        // Fix the west box --the topic box.
        Box topicBox= new Box(BoxLayout.Y_AXIS);
        Border border= BorderFactory.createBevelBorder(BevelBorder.LOWERED, Color.red, Color.red);
        topicBox.setBorder(border);
        topicBox.add(Box.createVerticalStrut(10));
        
        // jlabelBox contains a horizontal strut, select, and horizontal glue
        Box jlabelBox= new Box(BoxLayout.X_AXIS);
        jlabelBox.add(Box.createRigidArea(new Dimension(10,10)));
        JLabel select= new JLabel("Select a topic:  ", JLabel.LEFT);
        jlabelBox.add(select);
        jlabelBox.add(Box.createRigidArea(new Dimension(10,10)));
        topicBox.add(jlabelBox);

        //jlistBox contains a horizontal strut, topicsJList, and horizontal glue.
        Box jlistBox= new Box(BoxLayout.X_AXIS);
        jlistBox.add(Box.createRigidArea(new Dimension(10,10)));
        topicsJList= new JList(tList);
        jlistBox.add(topicsJList);
        jlistBox.add(Box.createHorizontalGlue());
        topicBox.add(jlistBox);
        
        topicBox.add(Box.createGlue());
        
        
        ListModel model= topicsJList.getModel();        
        if (model.getSize() != 0) {
            topicsJList.setSelectedIndex(0);
        }
        topicsJList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        
        cp.add(topicBox, BorderLayout.WEST);
        
        cp.add(new JLabel("  "), BorderLayout.SOUTH);
        
        
        // Fix the north box
        JLabel game1= new JLabel("  Play a game to learn terminology in some topic.", SwingConstants.LEFT);
        JLabel game2= new JLabel("  First, choose a topic (on left) and click the topic button. A picture will appear.");
        JLabel game3= new JLabel("  Use the lists below to select a label (number) and then the term for that part.  ");
        JLabel game4= new JLabel("  Then click button 'OK'. If you are right, the term will appear in green;");
        JLabel game5= new JLabel("  otherwise, the term will be red, and you can try again.");
        
        Box buttons= new Box(BoxLayout.X_AXIS);
        
        buttons.add(topicButton);
        topicButton.addActionListener(buttonListener);
        
        jNumbers.removeAllItems();
        jNumbers.setEditable(false);
        buttons.add(jNumbers);
       
        jTerms.removeAllItems();
        jTerms.setEditable(false);
        buttons.add(jTerms);
        
        buttons.add(OKButton);
        OKButton.addActionListener(buttonListener);
  
        buttons.add(Box.createHorizontalGlue());
        
        Box northBox= new Box(BoxLayout.Y_AXIS);
        northBox.add(game1);
        northBox.add(game2);
        northBox.add(game3);
        northBox.add(game4);
        northBox.add(game5);
        northBox.add(Box.createVerticalStrut(10));
              
        northBox.add(buttons);
        northBox.add(Box.createVerticalStrut(10));
        
        Box northX= new Box(BoxLayout.X_AXIS);
        northX.add(northBox);
        northX.add(Box.createHorizontalGlue());
        cp.add(northX, BorderLayout.NORTH);
    }
    
    /** Place image given by file name f in the GUI. */
    public void placeImage(String f) {
        Image im= getImage(f);
        Container cp= getContentPane();
        cp.remove(jpanel);
        jpanel= new A7Panel(im, this);
        cp.add(jpanel, BorderLayout.CENTER);
        pack();
    }
    
    /** = the image for file name f, using this jframe's toolkit. */
    private Image getImage(String f) {
        Image image= null;
        try {
            if (thisQ.isApplet()) {
                URL url= thisQ.getClass().getResource(f);
                image= thisQ.getToolkit().getImage(url);
            } else {
                 image= getToolkit().getImage(new URL("file:" + f));
            }
        } 
        catch (MalformedURLException e) {
            System.err.println("Bad URL!");
            return null;
        }
        
        // set media tracker to wait for image to load.
        MediaTracker tracker= new MediaTracker(this);
        tracker.addImage(image,0);    
        
        // wait for image to load
        try { 
            tracker.waitForID(0); 
        }
        catch (InterruptedException e) {
            // handler.flashMessage(ImageHandler.LOAD_INTERRUPTED);
            return null;
        }
        return image;
    }
    
    /** Add n to the list of numbers for the user to choose from. */
    public void addToComboBox(Integer n) {
        jNumbers.addItem(n);
        jNumbers.setMaximumRowCount(jNumbers.getItemCount());
    }
    
    /** Add s to the list of terms for the user to choose from. */
    public void addToComboBox(String s) {
        jTerms.addItem(s);
        jTerms.setMaximumRowCount(jTerms.getItemCount());
    }

    /** Delete n from the list of numbers for the user to choose from.
        This also changes the JComboBox.*/
    public void removeFromComboBox(int n) {
        int size= jNumbers.getItemCount();
        // inv: items 0..k-1 are not equal to n
        for (int k= 0; k != size; k= k+1) {
            if (((Integer)(jNumbers.getItemAt(k))).equals(n)) {
                jNumbers.removeItemAt(k);
                if (jNumbers.getItemCount() != 0) {
                    jNumbers.setSelectedIndex(0);
                }
                return;
            }
        }
    }
    
    /** Delete s from the list of terms for the user to choose from. */
    public void removeFromComboBox(String s) {
        int size= jTerms.getItemCount();
        // inv: items 0..k-1 are not equal to s
        for (int k= 0; k != size; k= k+1) {
            if (((String)(jTerms.getItemAt(k))).equals(s)) {
                jTerms.removeItemAt(k);
                if (jTerms.getItemCount() != 0) {
                    jTerms.setSelectedIndex(0);
                }
                return;
            }
        }
    }
    
    /** Remove all elements from the numbers and terms ComboBoxes */
    public void emptyComboBoxes() {
        jNumbers.removeAllItems(); 
        jTerms.removeAllItems(); 
    }
    
    /** An instance responds to mouse clicks on the two buttons. */
    public class ButtonListener implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            Object ob= e.getSource();
            if (!(ob instanceof JButton)) {
                return;
            }
            
            JButton jb= (JButton) ob;
            if (jb == OKButton) {
                if (jNumbers.getSelectedIndex() == -1 ||
                    jTerms.getSelectedIndex() == -1) {
                    System.out.println("Cannot process OK click because a number or a term is not selected");
                    return;
                }
                
                Object on= jNumbers.getSelectedItem();
                int n= (Integer) on;
                
                Object oterm= jTerms.getSelectedItem();
                String term= (String) oterm;
                
                thisQ.associateTerm(term, n);
                repaint();
                return;
            }
            
            if (jb == topicButton) {
                Object n= topicsJList.getSelectedValue();
                if (n == null)
                    return;
                thisQ.startTopic((String) n);
                 
                return;
            }
        }
    }

}