import junit.framework.TestCase;

/**
 * A JUnit test case class for LieDemo.
 */
public class LieDataTester extends TestCase {
    
    /* Here are the contents of file test.htm
   * Checking for line breaks, multiple occurrences, etc.
   * 
        here is a true sentence. 
    <font color="red"> lie false whatever false 
    here</font>.
    truth. <font color="red">other false stuff.</font> here
  */
    
    public void testCounts() { 
        
        LieData test= new LieData("test.htm");
        
        // all hits
        //assertEquals("hits: 3; misses: 0", test.counts("false"));
        
        // mixture of hits and misses
        assertEquals("hits: 1; misses: 2", test.counts("here"));
        
        // all misses
        assertEquals("hits: 0; misses: 1", test.counts("true"));  
        
        // target not even in data          
        assertEquals("hits: 0; misses: 0", test.counts("georgia"));
    }


  
    
        
    public void testInLieSpan() {
          LieData test= new LieData("test.htm");
          assertEquals(false,test.inLieSpan("here",3));
          assertEquals(true,test.inLieSpan("lie",48));
          assertEquals(false,test.inLieSpan("truth",87));
    }
   
    
}
