/** Demo on 24 February */
public class D {
    
    /** =  n, with commas every 3 digits.
      Precondition: n >= 0.
      e.g. commafy(5341267) = 5,341,267 */
    public static String commafy(int n) {
        if (n < 1000)
            return "" +n;
        // n >= 1000
        return commafy(n/1000) + "," + to3(n%1000);
    }
    
    /** = p with at least 3 chars --add leading 0's if necessary */
    public static String to3(int p) {
        if (p < 10) return "00" + p;
        if (p < 100) return "0" + p;
        return  "" + p;
    }
    
    /** =  b^c. Precondition: c  0
           Property. b^c =  b * b^(c-1)*/
    public static double expslow(double b, int c) {
        if (c == 0)
            return 1;
        return b * expslow(b, c-1);
    }
    
    /** =  b^c. Precondition: c  0
           Property. b^c =  b * b^(c-1)
           Property. b^c = (b*b)^(c/2) for even c*/
    public static double expfast(double b, int c) {
        if (c == 0) return 1;
        //  c > 0
        if (c%2 == 0)
            return expfast(b*b, c/2);
        // c is odd
        return b * expfast(b, c-1);
    }
    
    /** =  the pair (b^c, no. of calls made).
           Precondition: c  0.
           Property: b^c = b * b^(c-1) */
    public static PairDI exp1slow(double b, int c) {
        if (c == 0) 
            return new PairDI(1.0, 1);
        // c > 0
        PairDI p= exp1slow(b, c-1);
        return new PairDI(b * p.d, p.i+1);
    }
    
    /** =  the pair (b^c, no. of calls made).
           Precondition: c  0*/
    public static PairDI exp1fast(double b, int c) {
        if (c == 0) 
            return new PairDI(1.0, 1);
            
        // c > 0
        if (c % 2 == 0) {
            PairDI p= exp1fast(b*b, c/2);
            return new PairDI(p.d, p.i+1);
        }
        // c is odd
        PairDI p= exp1fast(b, c-1);
        return new PairDI(b * p.d, p.i+1);
    }
    
}