import javax.swing.*;
import java.awt.*;
import java.awt.event.*;


/** An instance has two buttons, exactly one of which is always
    enabled. Click the enabled one and the other one becomes
    enabled. */
public class ButtonDemo1 extends JFrame 
                        implements ActionListener {
    
    /** Class invariant: exactly one of eastButton
        and westButton is enabled */
    private JButton westButton= new JButton("west");
    private JButton eastButton= new JButton("east");

    /** Constructor: a frame with two buttons */
 public ButtonDemo1() {
  super("mouse demo");
  
  Container cp= getContentPane();
  cp.add(westButton,BorderLayout.WEST);
  cp.add(eastButton,BorderLayout.EAST);
           
  westButton.setEnabled(false);
  eastButton.setEnabled(true);
 
  westButton.addActionListener(this);
  eastButton.addActionListener(this);
  
  pack();
  setVisible(true);
 }
        
 /** Process a click of a button */
 public void actionPerformed(ActionEvent e) {
  boolean b= eastButton.isEnabled();
  eastButton.setEnabled(!b);
  westButton.setEnabled(b);
 }

}