import acm.graphics.*;
import acm.program.*;
import acm.util.*;
import java.applet.*;
import java.awt.*;
import java.awt.event.*;

/** An instance is the game breakout. Start it by executing
    Breakout.main(null);
    */
public class Breakout extends GraphicsProgram {
    /** Width of the game display (all coordinates are in pixels) */
    private static final int WIDTH= 450;
    /** Height of the game display */
    private static final int HEIGHT= 610;
    
    /** Width of the paddle */
    private static final int PADDLE_WIDTH= 60;
    /** Height of the paddle */
    private static final int PADDLE_HEIGHT= 10;
    /** Offset of the paddle up from the bottom */
    private static final int PADDLE_Y_BOTTOM_OFFSET= 30;
    
    /** Number of bricks per row */
    private static final int NBRICKS_PER_ROW= 10;
    /** Number of rows of bricks, in range 1..10. */
    private static final int NBRICK_ROWS= 10;
    /** Horizontal separation between bricks */
    private static final int BRICK_SEP_H= 5;
    /** Vertical separation between bricks */
    private static final int BRICK_SEP_V= 4;
    
    /** Width of a brick */
    private static final int BRICK_WIDTH= WIDTH / NBRICKS_PER_ROW - BRICK_SEP_H;
    /** Height of a brick */
    private static final int BRICK_HEIGHT= 8;
    /** Offset of the top brick row from the top */
    private static final int BRICK_Y_BOTTOM_OFFSET= 71;
    
    /** Radius of the ball in pixels */
    private static final int BALL_RADIUS= 10;
    
    /** Number of turns */
    private static final int NTURNS= 3;
    
    /** Run the program as an application. Parameter args is not used.
        A hint on how it works. The main program creates an instance of
        the class, giving the constructor the width and height of the graphics
        panel. It then calls method run() to start the computation.
      */
    public static void main(String[] args) {
        String[] sizeArgs= { "width=" + WIDTH, "height=" + HEIGHT };
        new Breakout().start(sizeArgs);
    }
    
    /** Run the Breakout program. */
    public void run() {
        // Initialize and play the game.
    }
    
}
