import acm.graphics.*;
import java.awt.*;
import acm.program.*;

/** An instance maintains a graphics window on the monitor, which can be drawn on
  using pens, turtles, and other things. */
public class A5 extends GraphicsProgram {
    
    // The argument to method start, giving the width and height of the graphics window. */
    private static String[] sizeArgs= { "width=" + 500, "height=" + 500 };
    
    /** Constructor: a new Graphics Program with a window of size (500, 500) */
    public A5() {
        super();
        start(sizeArgs);
    }
    
    /** Add a to t's angle */
    public static void addAngle(double a, GTurtle t) {
        t.setDirection(t.getDirection() + a);
    }
    
    /** Demo */
    public static void demo() {
        A5 a= new A5();
        int pausetime= 3000;
        while (true) {
            a.removeAll();
            GTurtle t= a.getTurtle();
            a.radiate(0, 4, 200);
            a.pause(pausetime);
            
            a.multiPolygons(t, .95, 4, 100);
            a.pause(pausetime);
            
            a.radiate(.88, 360, 200);
            a.pause(pausetime);
            
            a.radiate(.95, 1000, 200);
            a.pause(pausetime);
            
            a.drawSpiral(.88, 500, 135, 1);
            a.pause(pausetime);
            
            a.drawSpiral(.88, 500, 89, 1);
            a.pause(pausetime);
            
            a.drawSpiral(.88, 500, 91, 1);
            a.pause(pausetime);
            
            a.drawSpiral(.88, 500, 135, 1);
            a.pause(pausetime);
            
            a.drawSpiral(.88, 500, 60, 1);
            a.pause(pausetime);
            
            a.drawSpiral(.88, 500, 120, 1);
            a.pause(pausetime);
            
            a.sierpinski(10, 400, 0, 400);
            a.pause(pausetime);
            
            a.sierpinski(10, 400, 1, 400);
            a.pause(pausetime);
            
            a.sierpinski(10, 400, 2, 400);
            a.pause(pausetime);
            
            a.sierpinski(10, 400, 5, 400);
            a.pause(pausetime);
            
            a.recursiveH(250, 250, 0, 250);
            a.pause(pausetime);
            
            a.recursiveH(250, 250, 1, 250);
            a.pause(pausetime);
            
            a.recursiveH(250, 250, 2, 250);
            a.pause(pausetime);
            
            a.recursiveH(250, 250, 3, 250);
            a.pause(pausetime);
            
            a.recursiveH(250, 250, 4, 250);
            a.pause(pausetime);
        }
        
    }
    
    /** = a new turtle that is at the Center of the window, faces east,
      is not hidden, and is ready to draw in red. */
    public GTurtle getTurtle() {
        GTurtle t= new GTurtle();
        this.add(t);
        t.setLocation(getWidth()/2, getHeight()/2);
        t.penDown();
        t.setColor(Color.red);
        t.setDirection(0);
        t.showTurtle();
        return t;
    }
    
    /** = a new pen that is at the Center of the window,
      is not hidden, and is ready to draw in black. */
    public GPen getPen() {
        GPen p= new GPen();
        this.add(p);
        p.setLocation(getWidth()/2, getHeight()/2);
        p.setColor(Color.black);
        p.showPen();
        return p;
    }
    
    /** = a representation of t, giving its location, color, and direction */
    public String toString(GTurtle t) {
        // Instructions: Take a look at what t.toString() produces. This new toString
        // function should produce the same thing except that, just before the closing
        // bracket this should appear: , direction=<direction>
        String s= t.toString();
        return s; // You need to change this line.
        
    }
    
    /** In the middle of the window, draw a red line 100 pixels to the right (east),
      and then a blue line 200 pixels down (south).
      Do this with a new turtle that moves at speed s, 0 <= s <= 1, with
      0 being slowest and 1 fastest. */
    public void drawTwoLines(double s) {
        GTurtle t= getTurtle();
        
        t.setSpeed(s);
        t.forward(100); // draw a line 100 pixels in the current direction (east) 
        
        addAngle(270, t); // add 270 degrees to the angle
        t.setColor(Color.blue);
        t.forward(200);
    }
    
    /** Draw an equilateral triangle of side length e and color c at turtle t's
      current position. UPON COMPLETION, THE FOLLOWING PROPERTIES SHOULD BE THE
      SAME AS WHEN THE METHOD STARTED: turtle position, turtle direction,
      pen color, and whether the pen is up or down.
      Precondition: the pen is down. */
    public void drawTriangle( GTurtle t, int e, Color c) {
        // Hint: each angle in an equilateral triangle is 60 degrees.
        // Note: Do NOT save the turtle position and direction in the beginning
        // and then restore them at the end. Instead, the turtle moves should be
        // such that the turtle ends up where it started and facing in the same
        // direction.
        // Put your Code here:
        
        
        
        /** When you have completed and tested this method, do the following
          instructions in the Interactions pane to learn about round-off error
          caused by using type double instead of the mathematical type real:
          
          a= new A5();
          t= a.getTurtle();
          System.out.println(a.toString(t));
          a.drawTriangle(t, 200, java.awt.Color.red);
          System.out.println(a.toString(t));
          
          You will see that t's location not the same before and after
          drawing the triangle. This is due to "round-off" errors that
          arise because type double uses only approximations to real numbers.
          
          This is OK here, because the pixels in the panel on which
          the drawing takes place are given by integers: the top left one is
          (0, 0) the one to its right is (1, 0), and so on. The turtle's
          drawing methods round double values to ints before actually drawing.
          
          Add a comment at the top of this file (A5.java) containing a
          cut-and-paste of the results in the Interaction pane of
          typing in the five lines specified in this comment.
          */
    }
    
    /** Use turtle t to draw six green equilateral triangles with side lengths d
      to form a hexagon, starting at the turtle's current position and direction.
      Upon completion, the following properties should be the same as when
      the method started: turtle position, turtle direction,
      and whether the pen is up or down.
      Precondition: the pen is down. */
    public void drawGreenHex(GTurtle t, int d) {
        // Note: Do not save any of the turtle's properties and then restore
        //       them at the end. It is not needed. Just use 6 calls on 
        //       procedures drawTriangle and addAngle (given above).
        //       You should test that t's final location and direction are
        //       the same as t's initial location and direction (except for
        //       roundoff error).
        // You can use a loop but it is not needed.
        
        
        
    }
    
    
    /** Remove all objects from the window (using removeAll();). Then
      draw a spiral as specified in drawSpiral(GTurtle, double, int, int, int) below,
      using a new turtle that starts in the middle of the window and faces WEST. */
    public void drawSpiral(double s, int n, int ang, int d) {
        
        
        
    }
    
    /**  Draw a spiral of n lines beginning at turtle t's current position and
      direction. Use angle ang between adjacent lines, and use s for
      the turtle's speed (0 is slowest, 1 fastest).
      Line 1 is d pixels long; line 2, 2*d pixels, ..., so each line i
      is d*i pixels long. The lines should alternate between blue, red,
      and green, in that order, with the first one being blue. 
      End with t's color and speed being the same as before the call, but its
      final position and angle will be as it is after the last line drawn.
      Precondition: pen is down.
      */
    private void drawSpiral(GTurtle t, double s, int n, int ang, int d) {
        // Hint: use a loop, not recursion, for this method
        
    }
    
    /** Draw an n-sided polygon using turtle t. Each side is d pixels long.
      The polygon should be drawn as fast as possible.
      These properties of t should end up the way they were at the beginning:
      position, direction, and pen properties.
      Precondition: pen is down*/
    public void drawPolygon(GTurtle t, int n, int d) {
        double initialSpeed= t.getSpeed();
        t.setSpeed(1);
        
        // angle is the angle between 2 adjacent sides
        double angle= ((n-2) * 180.0) / n; 
        for (int j= 0; j < n; j= j+1) {
            t.forward(d);
            addAngle(180 - angle, t);
        }
        t.setDirection(t.getDirection()%360);
        
        t.setSpeed(initialSpeed);
    }
    
    
    /** Remove all objects from the window (using removeAll();). Then draw
      90 n-sided polygons as specified in method multiPolygons given below,
      using a new turtle that starts in the middle of the window and faces WEST. */
    public void multiPolygons(double s, int n, int d) {
        
        
        
        
    }
    
    /** Draw 90 n-sided polygons of side length d using turtle t, with the
      turtle moving at speed s. The polygons are in alternating colors
      between blue and red. Each polygon starts at the same place, but
      but each one is at an angle 4 degrees more than the preceding one. All
      properties of the turtle are the same at the end as they
      were in the beginning.
      Precondition: pen is down. */
    private void multiPolygons(GTurtle t, double s, int n, int d) {
        
    }
    
    /**  Remove all objects from the window (using removeAll();). Then
      do as in radiate(GTurtle, double, int int) (below) using a new
      turtle that starts in the middle of the screen and faces east. */
    public void radiate(double s, int n, int d) {
        
    }
    
    /** Draw n straight radiating lines of length d at equal angles using
      Turtle t with the turtle moving at speed s. A line drawn at angle
      ang, 0 <= ang < 360, should be drawn with HSV color (ang, 1, 1).
      The turtle should end up with its initial color and speed, but
      its final position and angle may be different at the end of drawing.
      Precondition: n >= 2 and pen is down. */
    private void radiate(GTurtle t, double s, int n, int d){
        
        
        
    }
    
    /** Remove all objects from the graphics window and 
      draw a Sierpinksi triangle of depth d with side length sl
      with bottom left corner (x, y) and with a new pen.
      Precondition: d >= 0 and s > 0. */
    public void sierpinski(double x, double y, int d, double sl) {
        
        
    } 
    
    /** Using pen p, draw a Sierpinksi triangle of depth d with side length sl
      and bottom left corner (x, y). 
      Precondition: d >= 0 and sl > 0.*/
    private void sierpinski(GPen p, double x, double y, int d, double sl){ 
        
    }
    
    /** Remove all objects from the window and draw a Sierpinksi carpet of
      depth d with side length sl with top-left corner the top of left of the window.
      Use a new pen. Precondition: d >= 0 and sl > 0. */
    public void sierpinskicarpet(int d, double sl) {
        
    }
    
    /** Using pen p, draw a Sierpinksi carpet of depth d with side length sl and
      top left corner (x, y). 
      Precondition: d >= 0 and s > 0.*/
    private void sierpinskicarpet(GPen p, double x, double y, int d, double sl){
        
    }
    
    /** Remove all objects from the window and draw an draw an H-tree
      of depth d with center (x, y) and size s using a new pen.  
      Precondition: d >= 0 and s >= 0. */
    public void recursiveH(double x, double y, int d, double s) {
        
    }
    
    /** draw an H-tree of depth d and size s with center (x, y) using
      pen p.  
      Precondition: d >= 0 and s >= 0. */
    private void recursiveH(GPen p, double x, double y, int d, double s) {
        
    }
    
    /** Using pen p, fill the equilateral triangle of side length sl with
      bottom-left corner given by p.
      When done, the position of p should be as it was initially. */
    public void fillTriangle(GPen p, double sl) {
        double h= sl * Math.sqrt(.75);
        p.startFilledRegion();
        p.drawLine(sl, 0);
        p.drawLine(-sl/2, - h);
        p.drawLine(-sl/2, h);
        p.endFilledRegion();
    }
    
    /** Draw an H at center (x, y) of size s using pen p. */
    public void drawH(GPen p, double x, double y, double s) {
        
        
        
    }
    
    
    /** Using pen p, fill a square of size (sl, sl), with top-left corner given
      by p. Upon completion, p should be at its original position. */
    public void fillSquare(GPen p, double sl) {
        p.startFilledRegion();
        p.drawLine(sl, 0);
        p.drawLine(0, sl);
        p.drawLine(-sl, 0);
        p.drawLine(0, -sl);
        p.endFilledRegion();
    }
    
    /** = color in RGB color space
      formulae from http://en.wikipedia.org/wiki/HSV_color_space */
    public static Color HSV2RGB(HSV HSV) {
        double H= HSV.h;
        double S= HSV.s;
        double V= HSV.v;
        
        int Hi= (int)Math.floor(H / 60.0) % 6;
        
        double f= H / 60 - Hi;
        double p= V * (1.0 - S);
        double q= V * (1.0 - f * S);
        double t= V * (1.0 - (1.0 - f) * S);
        double R, G, B;
        
        if (Hi == 0) {
            R= V;  G= t;  B= p;
        }
        else if (Hi == 1) {
            R= q;  G= V;  B= p;
        }
        else if (Hi == 2) {
            R= p;  G= V;  B= t;
        }
        else if (Hi == 3) {
            R= p;  G= q;  B= V;
        }
        else if (Hi == 4) {
            R= t;  G= p;  B= V;
        }
        else { // {Hi == 5}
            R= V;  G= p;  B= q;
        }
        
        return new Color((int)Math.round(R * 255.0),
                         (int)Math.round(G * 255.0),
                         (int)Math.round(B * 255.0));
    }
}