import junit.framework.TestCase;
import java.awt.*;
/**
 * A JUnit test case class.
 * Every method starting with the word "test" will be called when running
 * the test with JUnit.
 */
public class A4Tester extends TestCase {

     /** Test complement */
    public void testComplement() {
        assertEquals(new Color(255-250, 255-0, 255-71),
                     A4Methods.complementRGB(new Color(250, 0, 71)));
    }
    
    /** Test method truncateTo5   */
    public void testTruncateTo5() {
        assertEquals("130.5",  A4Methods.truncate2Five(130.59));
        assertEquals("130.5",  A4Methods.truncate2Five(130.54));
        assertEquals("100.0",  A4Methods.truncate2Five(100));
        assertEquals("99.56",  A4Methods.truncate2Five(99.566));
        assertEquals("99.99",  A4Methods.truncate2Five(99.99));
        assertEquals("99.99",  A4Methods.truncate2Five(99.995));
        assertEquals("21.99",  A4Methods.truncate2Five(21.99575));
        assertEquals("21.99",  A4Methods.truncate2Five(21.994));
        assertEquals("10.01",  A4Methods.truncate2Five(10.013567));
        assertEquals("10.00",  A4Methods.truncate2Five(10.000000005));
        assertEquals("9.999",  A4Methods.truncate2Five(9.9999));
        assertEquals("9.999",  A4Methods.truncate2Five(9.9993));
        assertEquals("1.354",  A4Methods.truncate2Five(1.3546));
        assertEquals("1.354",  A4Methods.truncate2Five(1.3544));
        assertEquals("0.045",  A4Methods.truncate2Five(.0456));
        assertEquals("0.045",  A4Methods.truncate2Five(.0453));
        assertEquals("0.005",  A4Methods.truncate2Five(.0056));
        assertEquals("0.001",  A4Methods.truncate2Five(.0013));
        assertEquals("0.000",  A4Methods.truncate2Five(.0004));
        assertEquals("0.000",  A4Methods.truncate2Five(.0009999));
    }
             
    public void testround2Five() {
        /*E.g. round 1.3546 to 1.355. round 1.3544 to 1.354.
         E.g. round 21.995 to 22.00. round 21.994 to 21.99.
         E.g. round 130.59 to 130.6. round 130.54 to 130.5.
         */
        assertEquals("130.6",  A4Methods.round2Five(130.59));
        assertEquals("130.5",  A4Methods.round2Five(130.54));
        assertEquals("100.0",  A4Methods.round2Five(100));
        assertEquals("99.57",  A4Methods.round2Five(99.566));
        assertEquals("99.99",  A4Methods.round2Five(99.99));
        assertEquals("100.0",  A4Methods.round2Five(99.995));
        assertEquals("22.00",  A4Methods.round2Five(21.99575));
        assertEquals("21.99",  A4Methods.round2Five(21.994));
        assertEquals("10.01",  A4Methods.round2Five(10.013567));
        assertEquals("10.00",  A4Methods.round2Five(10.000000005));
        assertEquals("10.00",  A4Methods.round2Five(9.9999));
        assertEquals("9.999",  A4Methods.round2Five(9.9993));
        assertEquals("1.355",  A4Methods.round2Five(1.3546));
        assertEquals("1.354",  A4Methods.round2Five(1.3544));
        assertEquals("0.046",  A4Methods.round2Five(.0456));
        assertEquals("0.045",  A4Methods.round2Five(.0453));
        assertEquals("0.006",  A4Methods.round2Five(.0056));
        assertEquals("0.001",  A4Methods.round2Five(.0013));
        assertEquals("0.000",  A4Methods.round2Five(.0004));
        assertEquals("0.001",  A4Methods.round2Five(.0009999));
    }
    
    /** Test toString(...) functions   */
    public void testToStrings() {
        assertEquals("(30, 240, 230)",  A4Methods.toString(new Color(30, 240, 230)));

        
        
    }

    /** Test the translation functions */
    public void testTranslations() {
        Color rgb= new Color(255, 255, 255);
        CMYK cmyk= A4Methods.RGB2CMYK(rgb);
        assertEquals(0.0, cmyk.cyan());
        assertEquals(0.0, cmyk.magenta());
        assertEquals(0.0, cmyk.yellow());
        assertEquals(0.0, cmyk.black());
        
        rgb= new Color(0, 0, 0);
        cmyk= A4Methods.RGB2CMYK(rgb);
        assertEquals(0.0, cmyk.cyan());
        assertEquals(0.0, cmyk.magenta());
        assertEquals(0.0, cmyk.yellow());
        assertEquals(1.0, cmyk.black());
        
        rgb= new Color(217, 43, 164);
        cmyk= A4Methods.RGB2CMYK(rgb);
        assertEquals("0.000", A4Methods.round2Five(cmyk.cyan()));
        assertEquals("0.802", A4Methods.round2Five(cmyk.magenta()));
        assertEquals("0.244", A4Methods.round2Five(cmyk.yellow()));
        assertEquals("0.149", A4Methods.round2Five(cmyk.black()));
        
        
        // Test cmyk to rgb
        


        // Test rgb to hsv
        
        
        
        
        // Test hsv to rgb
        
       
    }
    

}
