/** An instance represents a CMYK value */
public class CMYK {
    /** Color cyan. 0  c  1. */
    private double c;
    
    /** Color magenta. 0  m  1. */
    private double m;
    
    /** Color yellow. 0  y  1. */
    private double y;
    
    /** Color black. 0  c  1. */
    private double k;
    
    /** Constructor: the CMYK value (c, m, y, k).
        Precondition: All components c, m, y, and k are 
         0 and  1.*/
    public CMYK(double c, double m, double y, double k) {
        this.c= c;
        this.m= m;
        this.y= y;
        this.k= k;
    }
    
    /** A representation of this CMYK color. */
    public String toString() {
        return A4Methods.toString(this);
    }
    
    /** = the cyan component of this CMYK value */
    public double cyan() {
        return c;
    }
    
    /** = the magenta component of this CMYK value */
    public double magenta() {
        return m;
    }
    
     /** = the yellow component of this CMYK value */
    public double yellow() {
        return y;
    }
    
    /** = the black (K) component of this CMYK value */
    public double black() {
        return k;
    }

}
