import java.awt.*;

/** Contains static methods of assignment A4 */
public class A4Methods {
    
    /** = the complement of color rgb. */
    public static Color complementRGB(Color rgb) {
        // Stubbed in to compile. You write this one.
        return new Color(0, 0, 0);
    }
    
    
    /** = d, as a String, using exactly 5 characters.
      Precondition: 0 <= d <= 999.
      The truncated d will have one of the forms: ddd.d, dd.dd, and d.ddd.
      Examples are: 360.1, 29.50, 4.003, 0.001, and 0.000
      */
    public static String truncate2Five(double d) {
        assert 0 <= d  && d <= 999;
        
        // To get the desired output, do the following
        //   1. If d < 0.001, set d to 0.
        //      This prevents d appearing in scientific notation, e.g. 1.5E-6.
        //   2. Convert d to a string s, in the usual way.
        //   3. Note that s is guaranteed to have at least three chars: a decimal 
        //      pointand a digit on either side of it. Therefore, the simplest
        //      thing to do to make sure s has at least 5 chars is append "00" to s.
        //   4. Return the first five characters of s.
        // Stubbed in to compile. You write this one.
        return "0.000";
    }
    
    /** = d, but rounded (if necessary) to its first 5 characters.
      Precondition: 0 <= d <= 360.
      E.g. round 1.3546 to 1.355. round 1.3544 to 1.354.
      E.g. round 21.995 to 22.00. round 21.994 to 21.99.
      E.g. round 130.59 to 130.6. round 130.54 to 130.54.
      */
    public static String round2Five(double d) {
        // Note. DO NOT convert d to a string and then back to a double in order
        // to call truncateToFive. This function is easily written without this.
        // Rounding to an integer is usually done by adding .5 and
        // truncating to an integer, right?
        // E.g. Change 10.6 to 11.1 and truncate to 11
        // E.g. Change 10.4 to 10.9 and truncate to 10
        // The difference here is that the rounding takes place at a different place
        // depending on how big d is. Look at the examples in the specification.
        // Stubbed in to compile. You write this one.
        return "0.000";
    }
    
    
    
    /** = RGB value rgb in the form "(R, G, B)".
      Precondition: each of the rgb values is an integer
      in the range 0..255. */
    public static String toString(Color rgb) {
        // Stubbed in to compile. You write this one.
        return "";
    }
    
    /** = CMYK value cmyk in the form "(C, M, Y, K)". In the output,
      each of C, M, Y, and K should be exactly 5 characters long.
      Precondition: All parameters are   0 and  1. */
    public static String toString(CMYK cmyk) {
        // Stubbed in to compile. You write this one.
        return "";
    }
    
    /** = HSV value rgb in the form "(H, S, V)". In the output,
      each of H, S, and V should be exactly 5 characters long. */
    public static String toString(HSV hsv) {
        // Stubbed in to compile. You write this one.
        return "";
    }
    
    /** = color rgb in space CMYK, with the most black possible.
      Formulae from en.wikipedia.org/wiki/CMYK_color_model.*/
    public static CMYK RGB2CMYK(Color rgb) {
        // The RGB numbers are in the range 0..255.
        // First change them to range 0..1 by dividing them by 255.0.
        double R= rgb.getRed() / 255.0;
        double G= rgb.getGreen() / 255.0;
        double B= rgb.getBlue() / 255.0;
        
        
        
        // This is stubbed in. Write this function.
        return new CMYK(0, 0, 0, 0);
    }
    
    /** = color CMYK in space RGB.
      Formulae from en.wikipedia.org/wiki/CMYK_color_model.*/
    public static Color CMYK2RGB(CMYK cmyk) {
        // This is stubbed in to produce black. Write this function.
        return new Color(0, 0, 0);
    }
    
    /** = color rgb in HSV color space.
      Formulae from en.wikipedia.org/wiki/HSV_color_space. */
    public static HSV RGB2HSV(Color rgb) {
        // The RGB numbers are in the range 0..255.
        // First change them to range 0..1 by dividing them by 2.55.0.
        double R= rgb.getRed() / 255.0;
        double G= rgb.getGreen() / 255.;
        double B= rgb.getBlue() / 255.0;
        

        // This is stubbed in. Write this function.
        return new HSV(0, 0, 0);
    }
    
    /** = color in RGB color space
      Formulae from http://en.wikipedia.org/wiki/HSV_color_space */
    public static Color HSV2RGB(HSV HSV) {
       // This is stubbed in to produce black. Write this function.
       return new Color(0, 0, 0);
    }
}