/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import junit.framework.TestCase;

public class A4Tester
extends TestCase {
    public void testComplement() {
        A4Tester.assertEquals((Object)new Color(5, 255, 184), (Object)A4Methods.complementRGB(new Color(250, 0, 71)));
    }

    public void testTruncateTo5() {
        A4Tester.assertEquals((String)"130.5", (String)A4Methods.truncate2Five(130.59));
        A4Tester.assertEquals((String)"130.5", (String)A4Methods.truncate2Five(130.54));
        A4Tester.assertEquals((String)"100.0", (String)A4Methods.truncate2Five(100.0));
        A4Tester.assertEquals((String)"99.56", (String)A4Methods.truncate2Five(99.566));
        A4Tester.assertEquals((String)"99.99", (String)A4Methods.truncate2Five(99.99));
        A4Tester.assertEquals((String)"99.99", (String)A4Methods.truncate2Five(99.995));
        A4Tester.assertEquals((String)"21.99", (String)A4Methods.truncate2Five(21.99575));
        A4Tester.assertEquals((String)"21.99", (String)A4Methods.truncate2Five(21.994));
        A4Tester.assertEquals((String)"10.01", (String)A4Methods.truncate2Five(10.013567));
        A4Tester.assertEquals((String)"10.00", (String)A4Methods.truncate2Five(10.000000005));
        A4Tester.assertEquals((String)"9.999", (String)A4Methods.truncate2Five(9.9999));
        A4Tester.assertEquals((String)"9.999", (String)A4Methods.truncate2Five(9.9993));
        A4Tester.assertEquals((String)"1.354", (String)A4Methods.truncate2Five(1.3546));
        A4Tester.assertEquals((String)"1.354", (String)A4Methods.truncate2Five(1.3544));
        A4Tester.assertEquals((String)"0.045", (String)A4Methods.truncate2Five(0.0456));
        A4Tester.assertEquals((String)"0.045", (String)A4Methods.truncate2Five(0.0453));
        A4Tester.assertEquals((String)"0.005", (String)A4Methods.truncate2Five(0.0056));
        A4Tester.assertEquals((String)"0.001", (String)A4Methods.truncate2Five(0.0013));
        A4Tester.assertEquals((String)"0.000", (String)A4Methods.truncate2Five(4.0E-4));
        A4Tester.assertEquals((String)"0.000", (String)A4Methods.truncate2Five(9.999E-4));
    }

    public void testround2Five() {
        A4Tester.assertEquals((String)"130.6", (String)A4Methods.round2Five(130.59));
        A4Tester.assertEquals((String)"130.5", (String)A4Methods.round2Five(130.54));
        A4Tester.assertEquals((String)"100.0", (String)A4Methods.round2Five(100.0));
        A4Tester.assertEquals((String)"99.57", (String)A4Methods.round2Five(99.566));
        A4Tester.assertEquals((String)"99.99", (String)A4Methods.round2Five(99.99));
        A4Tester.assertEquals((String)"100.0", (String)A4Methods.round2Five(99.995));
        A4Tester.assertEquals((String)"22.00", (String)A4Methods.round2Five(21.99575));
        A4Tester.assertEquals((String)"21.99", (String)A4Methods.round2Five(21.994));
        A4Tester.assertEquals((String)"10.01", (String)A4Methods.round2Five(10.013567));
        A4Tester.assertEquals((String)"10.00", (String)A4Methods.round2Five(10.000000005));
        A4Tester.assertEquals((String)"10.00", (String)A4Methods.round2Five(9.9999));
        A4Tester.assertEquals((String)"9.999", (String)A4Methods.round2Five(9.9993));
        A4Tester.assertEquals((String)"1.355", (String)A4Methods.round2Five(1.3546));
        A4Tester.assertEquals((String)"1.354", (String)A4Methods.round2Five(1.3544));
        A4Tester.assertEquals((String)"0.046", (String)A4Methods.round2Five(0.0456));
        A4Tester.assertEquals((String)"0.045", (String)A4Methods.round2Five(0.0453));
        A4Tester.assertEquals((String)"0.006", (String)A4Methods.round2Five(0.0056));
        A4Tester.assertEquals((String)"0.001", (String)A4Methods.round2Five(0.0013));
        A4Tester.assertEquals((String)"0.000", (String)A4Methods.round2Five(4.0E-4));
        A4Tester.assertEquals((String)"0.001", (String)A4Methods.round2Five(9.999E-4));
    }

    public void testToStrings() {
        A4Tester.assertEquals((String)"(30, 240, 230)", (String)A4Methods.toString(new Color(30, 240, 230)));
        A4Tester.assertEquals((String)"(1.000, 0.500, 0.300)", (String)A4Methods.toString(new HSV(1.0, 0.5, 0.3)));
        A4Tester.assertEquals((String)"(1.000, 0.546, 0.300)", (String)A4Methods.toString(new HSV(1.0, 0.54623, 0.3)));
        A4Tester.assertEquals((String)"(1.000, 0.500, 0.300, 0.000)", (String)A4Methods.toString(new CMYK(1.0, 0.5, 0.3, 0.0)));
    }

    public void testTranslations() {
        Color rgb = new Color(255, 255, 255);
        CMYK cmyk = A4Methods.RGB2CMYK(rgb);
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.cyan());
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.magenta());
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.yellow());
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.black());
        rgb = new Color(0, 0, 0);
        cmyk = A4Methods.RGB2CMYK(rgb);
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.cyan());
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.magenta());
        A4Tester.assertEquals((Object)0.0, (Object)cmyk.yellow());
        A4Tester.assertEquals((Object)1.0, (Object)cmyk.black());
        rgb = new Color(217, 43, 164);
        cmyk = A4Methods.RGB2CMYK(rgb);
        A4Tester.assertEquals((String)"0.000", (String)A4Methods.round2Five(cmyk.cyan()));
        A4Tester.assertEquals((String)"0.802", (String)A4Methods.round2Five(cmyk.magenta()));
        A4Tester.assertEquals((String)"0.244", (String)A4Methods.round2Five(cmyk.yellow()));
        A4Tester.assertEquals((String)"0.149", (String)A4Methods.round2Five(cmyk.black()));
        rgb = new Color(0, 0, 0);
        HSV hsv1 = A4Methods.RGB2HSV(rgb);
        A4Tester.assertEquals((String)"0.000", (String)A4Methods.round2Five(hsv1.hue()));
        A4Tester.assertEquals((String)"0.000", (String)A4Methods.round2Five(hsv1.val()));
        CMYK cmyk2 = new CMYK(1.0, 1.0, 1.0, 1.0);
        rgb = A4Methods.CMYK2RGB(cmyk2);
        A4Tester.assertEquals((int)0, (int)rgb.getRed());
        A4Tester.assertEquals((int)0, (int)rgb.getGreen());
        A4Tester.assertEquals((int)0, (int)rgb.getBlue());
        CMYK cmyk3 = new CMYK(0.35, 0.38, 0.65, 0.0);
        rgb = A4Methods.CMYK2RGB(cmyk3);
        A4Tester.assertEquals((int)166, (int)rgb.getRed());
        A4Tester.assertEquals((int)158, (int)rgb.getGreen());
        A4Tester.assertEquals((int)89, (int)rgb.getBlue());
        CMYK cmyk4 = new CMYK(0.123, 0.467, 0.837, 0.6789);
        rgb = A4Methods.CMYK2RGB(cmyk4);
        A4Tester.assertEquals((int)72, (int)rgb.getRed());
        A4Tester.assertEquals((int)44, (int)rgb.getGreen());
        A4Tester.assertEquals((int)13, (int)rgb.getBlue());
        Color rgb4 = new Color(201, 201, 201);
        HSV hsv5 = A4Methods.RGB2HSV(rgb4);
        A4Tester.assertEquals((String)"0.000", (String)A4Methods.truncate2Five(hsv5.hue()));
        A4Tester.assertEquals((String)"0.000", (String)A4Methods.truncate2Five(hsv5.sat()));
        A4Tester.assertEquals((String)"0.788", (String)A4Methods.truncate2Five(hsv5.val()));
        rgb4 = new Color(255, 201, 121);
        HSV hsv6 = A4Methods.RGB2HSV(rgb4);
        A4Tester.assertEquals((String)"35.82", (String)A4Methods.truncate2Five(hsv6.hue()));
        A4Tester.assertEquals((String)"0.525", (String)A4Methods.truncate2Five(hsv6.sat()));
        A4Tester.assertEquals((String)"1.000", (String)A4Methods.truncate2Five(hsv6.val()));
        rgb4 = new Color(255, 25, 121);
        HSV hsv7 = A4Methods.RGB2HSV(rgb4);
        A4Tester.assertEquals((String)"334.9", (String)A4Methods.truncate2Five(hsv7.hue()));
        A4Tester.assertEquals((String)"0.901", (String)A4Methods.truncate2Five(hsv7.sat()));
        A4Tester.assertEquals((String)"1.000", (String)A4Methods.truncate2Five(hsv7.val()));
        rgb4 = new Color(146, 255, 146);
        HSV hsv8 = A4Methods.RGB2HSV(rgb4);
        A4Tester.assertEquals((String)"120.0", (String)A4Methods.truncate2Five(hsv8.hue()));
        A4Tester.assertEquals((String)"0.427", (String)A4Methods.truncate2Five(hsv8.sat()));
        A4Tester.assertEquals((String)"1.000", (String)A4Methods.truncate2Five(hsv8.val()));
        rgb4 = new Color(146, 20, 214);
        HSV hsv9 = A4Methods.RGB2HSV(rgb4);
        A4Tester.assertEquals((String)"278.9", (String)A4Methods.truncate2Five(hsv9.hue()));
        A4Tester.assertEquals((String)"0.906", (String)A4Methods.truncate2Five(hsv9.sat()));
        A4Tester.assertEquals((String)"0.839", (String)A4Methods.truncate2Five(hsv9.val()));
        HSV hsv3 = new HSV(40.0, 0.72, 0.78);
        rgb = A4Methods.HSV2RGB(hsv3);
        A4Tester.assertEquals((int)199, (int)rgb.getRed());
        A4Tester.assertEquals((int)151, (int)rgb.getGreen());
        A4Tester.assertEquals((int)56, (int)rgb.getBlue());
        hsv3 = new HSV(70.9, 0.718, 0.78);
        rgb = A4Methods.HSV2RGB(hsv3);
        A4Tester.assertEquals((int)173, (int)rgb.getRed());
        A4Tester.assertEquals((int)199, (int)rgb.getGreen());
        A4Tester.assertEquals((int)56, (int)rgb.getBlue());
        hsv3 = new HSV(120.0, 0.42, 1.0);
        rgb = A4Methods.HSV2RGB(hsv3);
        A4Tester.assertEquals((int)148, (int)rgb.getRed());
        A4Tester.assertEquals((int)255, (int)rgb.getGreen());
        A4Tester.assertEquals((int)148, (int)rgb.getBlue());
        hsv3 = new HSV(195.5, 0.42, 0.89);
        rgb = A4Methods.HSV2RGB(hsv3);
        A4Tester.assertEquals((int)132, (int)rgb.getRed());
        A4Tester.assertEquals((int)202, (int)rgb.getGreen());
        A4Tester.assertEquals((int)227, (int)rgb.getBlue());
        hsv3 = new HSV(262.2, 0.9, 0.36);
        rgb = A4Methods.HSV2RGB(hsv3);
        A4Tester.assertEquals((int)40, (int)rgb.getRed());
        A4Tester.assertEquals((int)9, (int)rgb.getGreen());
        A4Tester.assertEquals((int)92, (int)rgb.getBlue());
        hsv3 = new HSV(339.9, 0.9, 1.0);
        rgb = A4Methods.HSV2RGB(hsv3);
        A4Tester.assertEquals((int)255, (int)rgb.getRed());
        A4Tester.assertEquals((int)25, (int)rgb.getGreen());
        A4Tester.assertEquals((int)102, (int)rgb.getBlue());
        hsv3 = new HSV(332.8, 1.0, 1.0);
        rgb = A4Methods.HSV2RGB(hsv3);
        A4Tester.assertEquals((int)255, (int)rgb.getRed());
        A4Tester.assertEquals((int)0, (int)rgb.getGreen());
        A4Tester.assertEquals((int)116, (int)rgb.getBlue());
    }
}

