/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class A4Methods {
    public static Color complementRGB(Color rgb) {
        return new Color(255 - rgb.getRed(), 255 - rgb.getGreen(), 255 - rgb.getBlue());
    }

    public static String truncate2Five(double d) {
        assert (0.0 <= d && d <= 999.0);
        if (d < 0.001) {
            d = 0.0;
        }
        String s = d + "00";
        return s.substring(0, 5);
    }

    public static String round2Five(double d) {
        if (d >= 100.0) {
            return A4Methods.truncate2Five(d + 0.05);
        }
        if (d >= 10.0) {
            return A4Methods.truncate2Five(d + 0.005);
        }
        return A4Methods.truncate2Five(d + 5.0E-4);
    }

    public static String toString(Color rgb) {
        return "(" + rgb.getRed() + ", " + rgb.getGreen() + ", " + rgb.getBlue() + ")";
    }

    public static String toString(CMYK cmyk) {
        return "(" + A4Methods.round2Five(cmyk.cyan()) + ", " + A4Methods.round2Five(cmyk.magenta()) + ", " + A4Methods.round2Five(cmyk.yellow()) + ", " + A4Methods.round2Five(cmyk.black()) + ")";
    }

    public static String toString(HSV hsv) {
        return "(" + A4Methods.round2Five(hsv.hue()) + ", " + A4Methods.round2Five(hsv.sat()) + ", " + A4Methods.round2Five(hsv.val()) + ")";
    }

    public static CMYK RGB2CMYK(Color rgb) {
        double R = (double)rgb.getRed() / 255.0;
        double G = (double)rgb.getGreen() / 255.0;
        double B = (double)rgb.getBlue() / 255.0;
        double Cprime = 1.0 - R;
        double Mprime = 1.0 - G;
        double Yprime = 1.0 - B;
        if (Cprime >= 1.0 && Mprime >= 1.0 && Yprime >= 1.0) {
            return new CMYK(0.0, 0.0, 0.0, 1.0);
        }
        double K = Math.min(Math.min(Cprime, Mprime), Yprime);
        double C = (Cprime - K) / (1.0 - K);
        double M = (Mprime - K) / (1.0 - K);
        double Y = (Yprime - K) / (1.0 - K);
        return new CMYK(C, M, Y, K);
    }

    public static Color CMYK2RGB(CMYK cmyk) {
        double C = cmyk.cyan();
        double M = cmyk.magenta();
        double Y = cmyk.yellow();
        double K = cmyk.black();
        double oneMinusK = 1.0 - K;
        double R = (1.0 - C) * oneMinusK;
        double G = (1.0 - M) * oneMinusK;
        double B = (1.0 - Y) * oneMinusK;
        return new Color((int)Math.round(R * 255.0), (int)Math.round(G * 255.0), (int)Math.round(B * 255.0));
    }

    public static Color CMYK2RGBJanHeeSung(CMYK cmyk) {
        double R = (1.0 - cmyk.cyan()) * (1.0 - cmyk.black());
        double G = (1.0 - cmyk.magenta()) * (1.0 - cmyk.black());
        double B = (1.0 - cmyk.yellow()) * (1.0 - cmyk.black());
        Integer r = (int)(R * 255.0 + 0.5);
        Integer g = (int)(G * 255.0 + 0.5);
        Integer b = (int)(B * 255.0 + 0.5);
        return new Color(r, g, b);
    }

    public static HSV RGB2HSV(Color rgb) {
        double MIN;
        double B;
        double G;
        double R = (double)rgb.getRed() / 255.0;
        double MAX = Math.max(R, Math.max(G = (double)rgb.getGreen() / 255.0, B = (double)rgb.getBlue() / 255.0));
        double H = MAX == (MIN = Math.min(R, Math.min(G, B))) ? 0.0 : (MAX == R && G >= B ? 60.0 * (G - B) / (MAX - MIN) + 0.0 : (MAX == R && G < B ? 60.0 * (G - B) / (MAX - MIN) + 360.0 : (MAX == G ? 60.0 * (B - R) / (MAX - MIN) + 120.0 : 60.0 * (R - G) / (MAX - MIN) + 240.0)));
        double S = MAX == 0.0 ? 0.0 : 1.0 - MIN / MAX;
        double V = MAX;
        return new HSV(H, S, V);
    }

    public static Color HSV2RGB(HSV HSV2) {
        double B;
        double G;
        double R;
        double H = HSV2.hue();
        double S = HSV2.sat();
        double V = HSV2.val();
        int Hi = (int)Math.floor(H / 60.0) % 6;
        double f = H / 60.0 - (double)Hi;
        double p = V * (1.0 - S);
        double q = V * (1.0 - f * S);
        double t = V * (1.0 - (1.0 - f) * S);
        if (Hi == 0) {
            R = V;
            G = t;
            B = p;
        } else if (Hi == 1) {
            R = q;
            G = V;
            B = p;
        } else if (Hi == 2) {
            R = p;
            G = V;
            B = t;
        } else if (Hi == 3) {
            R = p;
            G = q;
            B = V;
        } else if (Hi == 4) {
            R = t;
            G = p;
            B = V;
        } else {
            R = V;
            G = p;
            B = q;
        }
        return new Color((int)Math.round(R * 255.0), (int)Math.round(G * 255.0), (int)Math.round(B * 255.0));
    }
}

