import java.awt.*;

/** Assignment A5 */
public class A5 extends Turtle {
    
    
    /** Constructor: a black turtle starting at the middle of the
      panel with angle 0 (looking east).
      East (right) is angle 0; north (up), 90; west (left), 180;
      South (down). 270. The pen is down.*/
    public A5() {
        super();
    }
    
    /** Constructor: a new turtle that has a ball drawn at the turtle's
      position. The turtle is initially at (x, y), the pen is color c,
      the ball's radius is r, and the ball moves with speed (vx, vy). */
    public A5(double x, double y, double r, Color c,
              double vx, double vy){
        
        // PUT YOUR CODE HERE AND REMOVE THIS COMMENT
    }
    
    /** Constructor: a new turtle that has a ball drawn at the turtle's
      position. The turtle is initially at the center of the panel,
      the pen is black, the ball's radius is r, and the ball moves
      with speed (vx, vy).
      */
    public A5(double vx, double vy, double r){
        
        // PUT YOUR CODE HERE AND REMOVE THIS COMMENT
    }
    
    /** Place the turtle in the center of the panel, facing east, and
      clear the window (make it white). */
    public void moveToCenter() {
        jumpTo(getWidth()/2, getHeight()/2, 0);
        clear();
    }
    
    
    /** Move the ball (vx, vy), making it bounce off the panel walls.
      Follow the the directions given in handout A5.
      Precondition: this object was created with one of the two
      ball constructors.*/
    public void moveOnce() {
        
        // PUT YOUR CODE HERE AND REMOVE THIS COMMENT
        
        
        
    }
    
    /** Put balls b1 and b2 into perpetual motion. That is, forever, move
      * both balls once and then pause 100 ms.
      Precondition: b1 and b2 are different objects and were created with
      one of the two ball constructors.*/
    public static void perpetual2(A5 b1, A5 b2) {
        
        // PUT YOUR CODE HERE AND REMOVE THIS COMMENT
    }
    
 
    
    /** Draw a black line 30 pixels to the right (east) and then
      a blue line 35 pixels down (south).
      Precondition: the turtle is facing east.*/
    public void drawTwoLines() {
        Color save= getColor();
        
        moveAhead(30); // draw a line 30 pixels to the right (east) 
        addAngle(270); // add 270 degrees to the angle
        setColor(Color.blue);
        moveAhead(35);
        
        setColor(save);
    }
    
    /** = a representation of this Turtle, giving its position, whether
          the pen is down or up, and the pen color, in that order. */
    public String toString() {
        /** ATTENTION. The x- and y-coordinates should be rounded using function
          * Math.round(...) and cast to type int before outputting them */
        
        return "";
    }
    
    /** Draw a red equilateral triangle of side length e at the turtle's
      current position. UPON COMPLETION, THE FOLLOWING PROPERTIES SHOULD BE THE
      SAME AS WHEN THE METHOD STARTED: turtle position, turtle direction,
      pen color, and whether the pen is up or down.
      Precondition: the pen is down. */
    public void drawRedTriangle(double e) {
        // Hint: each angle in an equilateral triangle is 60 degrees. Remember to
        // save the current turtle color and restore it at the end.
       
        // PUT YOUR CODE HERE AND REMOVE THIS COMMENT
        
        /** When you have completed and tested this method, do the following
          instructions in the interactions pane. When done, place a comment at the
          top of this file, saying that you did it. Also, place in that comment the two
          values produced by the calls p.getX() (see below).
          
          The purpose is to learn something about round-off error caused by using
          type double instead of the mathematical type real (which is not implemented
          in Java).
          
          Execute the following in the interactions pane, one by one:
          
          p= new A5();
          p.getX()
          p.drawRedTriangle(300);
          p.getX()
          
          You will see that the x-coordinate is not the same before and after
          drawing the triangle. This is due to "round-off" errors that
          arise because type double uses only approximations to real numbers.
          
          This is OK here, because the pixels in the panel on which
          the drawing takes place are given by integers: the top left one is
          (0, 0) the one to its right is (1, 0), and so on. The turtle's
          drawing methods round double values to ints before actually drawing.
          */
    }
    
    /** Draw six red equilateral triangles to form a hexagon, starting at the
      turtle's current position and angle.
      Precondition: the pen is down. */
    public void drawRedHex(int d) {
        // PUT YOUR CODE HERE AND REMOVE THIS COMMENT
        
    }
    
    /** Move the turtle to the middle of the drawing panel (without drawing!), clear the
      draw panel, and point the turtle facing west (180 degrees).
      Then draw a spiral of n lines, using an angle of ang between adjacent lines
      and pausing ms milliseconds after each line.
      Line 1 is d pixels long; line 2, 2*d pixels, ..., so each line i
      is 2*i pixels long. The lines should alternate between blue, red, and green,
      in that order, with the first one being blue. */
    public void spiral(int n, int ang, int d, int m) {
        
        // PUT YOUR CODE HERE (if you do this one) AND REMOVE THIS COMMENT
        
    }
    
    /** Move the turtle to the middle of the drawing panel (without drawing!) and
      make the turtle face east (0 degrees). clear the drawing panel.
      Draw n straight radiating lines of length d at equal angles.
      Pause m milliseconds after each line. A line drawn at angle
      ang, 0 <= and < 360, should be drawn with the HSV color
      (ang, 1, 1). Precondition: n >= 2. */
    public void radiate( int n, int d, int m){
        
        // PUT YOUR CODE HERE (if you do this one) AND REMOVE THIS COMMENT
          
    }
    
    /** Draw an n-sided polygon, ending up with the turtle
      being where it started out and facing the same
      direction, and with the pen properties the same, too.
      Each side is d pixels long. */
    public void drawPolygon(int n, int d) {
        // angle is the angle between 2 adjacent sides
        double angle= ((n-2) * 180.0) / n; 
        for (int j= 0; j < n; j= j+1) {
            moveAhead(d);
            addAngle(180 - angle);
        }
    }
    
    /** Move the turtle to the middle of the drawing panel (without drawing!),
      clear the draw panel, and point the turtle facing sout (270 degrees).
      Draw 90 n-sided polygons of side length d, alternating
      between red and orange. Each one starts at the same place,
      but each one is at an angle 4 degrees more than the
      preceding one. Pause m milliseconds after each one. All
      properties of the turtle are the same at the end as they
      were in the beginning. */
    public void multiPolygons(int n, int d, int m) {
        
         // PUT YOUR CODE HERE (if you do this one) AND REMOVE THIS COMMENT
        
    }

    
    /** Make sure that the graphics panel is as large as possible in the
      window. Clear the window and place the turtle facing east at position
      (1*width/5, 1*height/3). Then draw a Koch snowflake of depth d
      with line segment length F. Pause msec microseconds after drawing each
      line segment.
      Precondition: d >= 0*/
    public void Koch(int d, double F, int msec) {
        setPanelSize();
        clear();
        jumpTo(1*getWidth()/5, 1*getHeight()/3, 0);
        if (d == 0) {
            moveAhead(F);  pause(msec);
            addAngle(-120);
            moveAhead(F);  pause(msec);
            addAngle(-120);
            moveAhead(F);  pause(msec);
            return;
        }
        
        KochL(d-1, F, msec);
        addAngle(-120);
        KochL(d-1, F, msec);
        addAngle(-120);
        KochL(d-1, F, msec);
        
    }
    
    /** Draw a KochL snowflake of depth d with the current turtle.
      Parameters d, F, and msec are as in procedure Koch. 
      Precondition: d >= 0 */
    private void KochL(int d, double F, int msec) {
        if (d == 0) {
            moveAhead(F); pause(msec);
            addAngle(60);
            moveAhead(F);  pause(msec);
            addAngle(-120);
            moveAhead(F);  pause(msec);
            addAngle(60);
            moveAhead(F); pause(msec);
            return;
        }
        
        KochL(d-1, F, msec); 
        addAngle(60);
        KochL(d-1, F, msec);
        addAngle(-120);
        KochL(d-1, F, msec);
        addAngle(60);
        KochL(d-1, F, msec);
    }
    


    

    
}