
% Homework 4
% setupGUI.m
% CS 1109, Summer 2011
% July 18

% This script sets up the GUI for the Game of Life simulator. It adds the
% buttons, image window and sets the figure properties

% Set figure window properties
set(gcf, 'menubar', 'none', 'numbertitle', 'off')
set(gcf, 'position', [360 260 500 425]);
set(gcf, 'name', 'Conway''s Game of Life', 'resize', 'off');

% Button that runs the simulation
runButton = uicontrol('style', 'pushbutton', 'string', 'Run', ...
    'fontsize', 12, 'position', [125, 400, 50, 20], 'callback', ...
    'run = true;');

% Button to stop the simulation
freezeButton = uicontrol('style', 'pushbutton', 'string', 'Stop', ...
    'fontsize', 12, 'position', [200, 400, 50, 20], 'callback', ...
    'freeze = true;');

% Button to quit
quitButton = uicontrol('style', 'pushbutton', 'string', 'Quit', ...
    'fontsize', 12, 'position', [275, 400, 50, 20], ...
    'callback', 'quit = true; close;');

% Button to start over
imgType = 'cdata';
resetCallBack = ['[blueCells redCells] = initPattern(startingPattern);' ...
    'set(imageHandle, imgType, cat(3,redCells,z,blueCells));' ...
    'generation = 0;'];
resetButton = uicontrol('style', 'pushbutton', 'string', 'Reset', ...
    'fontsize', 12, 'position', [350, 400, 50, 20], ...
    'callback', resetCallBack);

% Create a text box showing generation #
stepNumberHandle = uicontrol('style', 'text', 'string', ...
    'Generation: 0', 'fontsize', 12, 'position', [155 25 200 20], ...
    'backgroundcolor', [0.8 0.8 0.8]);

% To make sure button blend with frame background
shadeOfGray = get(gcf, 'color');

% Radio button to select starting pattern. First, create the button group
radioHandle = uibuttongroup('visible','off', 'position', [0 0 .17 1], ...
    'backgroundcolor', shadeOfGray, 'bordertype', 'none');

% Create six radio buttons in the button group, one for each initial
% pattern
pattern(1) = uicontrol('style', 'radio', 'string', 'Glider', ...
    'position', [5 325 80 35], 'parent', radioHandle, ...
    'handlevisibility', 'off', 'backgroundcolor', shadeOfGray, ...
    'fontsize', 10);
pattern(2) = uicontrol('style', 'radio','String', 'Crab', ...
    'position', [5 275 80 35], 'parent', radioHandle, ...
    'handlevisibility', 'off', 'backgroundcolor', shadeOfGray, ...
    'fontsize', 10);
pattern(3) = uicontrol('style', 'radio','String', 'Die Hard', ...
    'position', [5 225 80 35], 'parent', radioHandle, ...
    'handlevisibility', 'off', 'backgroundcolor', shadeOfGray, ...
    'fontsize', 10);
pattern(4) = uicontrol('style', 'radio','String', ...
    '<html>Switch<br>Engine', 'position', [5 175 80 35], 'parent', ...
    radioHandle, 'handlevisibility', 'off', 'backgroundcolor', ...
    shadeOfGray, 'fontsize', 10);
pattern(5) = uicontrol('style', 'radio','String', ...
    '<html>Glider<br>&nbsp;Gun', 'position', [5 125 80 35], 'parent', ...
    radioHandle, 'handlevisibility', 'off', 'backgroundcolor', ...
    shadeOfGray, 'fontsize', 10);
pattern(6) = uicontrol('style', 'radio','String', 'Random', ...
    'position', [5 75 80 35], 'parent', radioHandle, ...
    'handlevisibility', 'off', 'backgroundcolor', shadeOfGray, ...
    'fontsize', 10);

% Initialize the radio button group properties. 
set(radioHandle,'selectionchangefcn', 'radioButtonCallback');
set(radioHandle,'visible','on');

% Set axis properties
axis equal
axis tight
axis off
