
% Homework 4
% initPattern.m
% CS 1109, Summer 2011
% July 18

% This file holds the set of functions that contain the definitions of the
% various initial patterns that the user can select via the GUI.

function [blueCells redCells] = initPattern(patternName)
% This is a wrapper function for the other initialization routines that
% actually write to our cell array

global gridSize;

gridSize = 90;

% Jump table, based on user's selected starting pattern
if strcmp(patternName, 'glider')
    [blueCells redCells] = initGlider;
elseif strcmp(patternName, 'crab')
    [blueCells redCells] = initCrab;    
elseif strcmp(patternName, 'die_hard')
    [blueCells redCells] = initDieHard;
elseif strcmp(patternName, 'glider_gun')
    [blueCells redCells] = initGliderGun;
elseif strcmp(patternName, 'switch_engine')
    [blueCells redCells] = initSwitchEngine;
else
    [blueCells redCells] = initRandom;
end

end



function [blueCells redCells] = initRandom
% This function populates the cells at random

global gridSize;

blueCells = zeros(gridSize, gridSize);
redCells = blueCells;

numToSeed = (gridSize * gridSize) / 4;

while (numToSeed > 0)
    x = randi(gridSize - 2, 1) + 1;
    y = randi(gridSize - 2, 1) + 1;
    if (blueCells(x, y) | redCells(x, y))
        continue;
    end
    if (rand <= 0.5)
        blueCells(x, y) = 1;
    else
        redCells(x, y) = 1;
    end
    numToSeed = numToSeed - 1;
end
end


function [blueCells redCells] = initGlider
% This contains the pattern for a glider, a pattern that repeats itself
% while descending the drawing space diagonally.

global gridSize;


blueCells = zeros(gridSize, gridSize);
redCells = blueCells;

redCells(2,2) = 1;
redCells(2,4) = 1;
blueCells(3,3) = 1;
blueCells(3,4) = 1;
blueCells(4,3) = 1;

end


function [blueCells redCells] = initDieHard
% This contains the pattern for 'Die Hard'. This pattern is a methuselah
% --- it grows much larger than its starting configuration, before
% eventually fizzling out to die.

global gridSize;

blueCells = zeros(gridSize, gridSize);
redCells = blueCells;

redCells(42, 47) = 1;
redCells(43, [41 42]) = 1;

blueCells(44, [42 46:48]) = 1;

end


function [blueCells redCells] = initCrab
% This contains the pattern for a crab, a kind of spaceship. It replicates
% itself while moving diagonally up the drawing space.

global gridSize;


blueCells = zeros(gridSize, gridSize);
redCells = blueCells;

redCells(40+31, 50+[29 30]) = 1;
redCells(40+32, 50+[28 29]) = 1;
redCells(40+33, 50+30) = 1;
redCells(40+34, 50+[32 33]) = 1;
redCells(40+35, 50+31) = 1;
blueCells(40+37, 50+[30 33]) = 1;
redCells(40+38, 50+[22 23]) = 1;
blueCells(40+38, 50+[29 30]) = 1;
redCells(40+39, 50+[21 22]) = 1;
blueCells(40+39, 50+28) = 1;
redCells(40+40, 50+23) = 1;
blueCells(40+40, 50+[28 30]) = 1;
redCells(40+41, 50+[25 26]) = 1;
blueCells(40+41, 50+29) = 1;
redCells(40+42, 50+25) = 1;
blueCells(40+42, 50+26) = 1;

end


function [blueCells redCells] = initSwitchEngine
% This contains the pattern for a switching engine. It moves in a
% diagonally upward fashion, while leaving behind a trail of blocks. It's
% an example of a puffer.

global gridSize;

blueCells = zeros(gridSize, gridSize);
redCells = blueCells;

redCells(55+[19 20], 55+[8 9]) = 1;
redCells(55+[27 28], 55+[16 17]) = 1;

redCells(56, 55+19) = 1;
redCells(57, 55+[2 3 4 13 19]) = 1;
redCells(58, 55+[1 5 12 20]) = 1;
redCells(59, 55+[2 3 13:16 19 20]) = 1;
redCells(60, 55+[4 5 7 8 18:20]) = 1;
redCells(61, 55+[6 7 19 21]) = 1;
redCells([62 63], 55+[20 28 29]) = 1;

end


function [blueCells redCells] = initGliderGun
% This contains the pattern for a Gosper glider gun. This pattern consists
% of two colliding pieces that continuously generates gliders.

global gridSize;

blueCells = zeros(gridSize, gridSize);
redCells = blueCells;

blueCells(13, 10+[13 14]) = 1;
blueCells(14, 10+[12 16]) = 1;
blueCells(15, 10+[1 2 11 17]) = 1;
blueCells(16, 10+[1 2 11 15 17 18]) = 1;
blueCells(17, 10+[11 17]) = 1;
blueCells(18, 10+[12 16]) = 1;
blueCells(19, 10+[13 14]) = 1;

redCells(11, 10+25) = 1;
redCells(12, 10+[23 25]) = 1;
redCells([13 14], 10+[21 22 35 36]) = 1;
redCells(15, 10+[21 22]) = 1;
redCells(16, 10+[23 25]) = 1;
redCells(17, 10+25) = 1;

end