function cipherTextString = getCipherText
% getCipherText: Loads ciphertext string from the file cipher.txt
%
%   This function loads the text from the file 'cipher.txt' and returns it
%   as a string. It takes no input parameters. It assumes that the file
%   'cipher.txt' exists and is in the same working directory as the
%   function. 
%
% USAGE: cipherTextString = getCipherText();
%

fid = fopen('cipher.txt');

if (fid == -1)
    error(['Error --- could not find file ''cipher.txt'' in working' ...
        'directory']);
end

cipherTextString = textscan(fid, '%s', 'WhiteSpace', '', 'Bufsize', ...
    1000000);
cipherTextString = char(cipherTextString{1});

end

