
function beautifyPlot(histData)
% beautifyPlot: Makes the plot generated by plotFreqs easier to read
%
%   This function modifies the x-axis tick labels so that rather than
%   listing the numbers 1--26, its lists the letters of the alphabet. It
%   also causes the height of each histogram bar to be printed at the top
%   of the bar. It accepts one input parameter, the vector containing the
%   frequency distribution of the various letters (i.e. the same vector
%   that is passed to plotFreqs).
%   
%   *** Call this at the very end of your plotFreqs function ***
%
% USAGE: beautifyPlot(frequencyVector);
%

% Set up tick labels and spacing
alphabet = ('a':'z')';
set(gca, 'xtick', 1:1:26);
set(gca, 'xticklabel', alphabet);

% Figure out the axis limits, to figure out the offset at which to print
% the bar labels
scale = axis;
offset = (scale(4)-scale(3)) / 60;

% Print the frequency count at the top of each histogram bar
for i = 1:1:26
    str = sprintf('%d', histData(i));
    text(i, histData(i) + offset, str, 'HorizontalAlignment', 'center');
end


end