function out = aPrime(m)
% Returns 1 if m is a prime number, 0 otherwise.

% For completeness we check for error, but it's not 
% required in your solution.
if (m<=0 || floor(m)~=m)
    disp('Error: argument must be an integer > 1')
    out= 0;
    return
end

% Check for divisors from 2 to floor(sqrt(m))
d= 2;  % first divisor 
dmax= floor(sqrt(m));
while ( d<=dmax && rem(m,d)~=0 )
    d= d+1;
end
if d<=dmax && rem(m,d)==0  % a proper divisor <m was found
    out= 0;
else
    out= 1;
end

