% Does the deck cycle back to the original arrangement using Cut3?

% original card deck
cards = CardDeck;
len = length(cards);

c = cards;   % current deck
n = 0;       % number of shuffles so far
N = 10000;   % maximum number of shuffles to try (to prevent infinite loop)
same = true; % are two decks (or cards) the same?

% Shuffle and compare in the first iteration or while decks are not the
% same
while n==0 || (~same && n < N)
    c = Cut3(c);
    n = n + 1;
    % compare the two vectors
    same = 1;
    k = 1;
    while k <= len && same
        same = strcmp(c{k}, cards{k});
        k = k + 1;
    end
end

if same
    disp(sprintf('The deck returns to the original state after %d shuffles.', n));
else
    disp(sprintf('The deck does not cycle back in %d shuffles.', N));
end

