function sd= MyShuffle(d)
% d is a one-dimensional cell array
% sd is the cell array after shuffling d
% The shuffle comprises two steps:
%  - cut the deck into two parts
%  - interleave the cards from the two parts until the part with fewer
%    cards have been completely incorporated.  It is up to you whether
%    to start from the top or the bottom.

n = length(d);
sd = cell(1,n);

% uniformly randomly choose the cut point
% the deck will be cut into two parts: [1, cut], and [cut + 1, n]
cut = ceil((n-1)*rand);

Top = d(1:cut);
Bot = d((cut+1):end);
m = min(cut, n-cut);

% the new deck will be in the order
% Bot{1} Top{1} Bot{2} Top{2} ...

for k=1:n
    if k<=2*m
        % the smaller part is not exhausted
        if rem(k, 2) == 0
            sd{k} = Top{k/2};
        else
            sd{k} = Bot{(k+1)/2};
        end
    else
        % append the remaining cards
        if 2*cut <= n
            % Top is the smaller part
            sd{k} = Bot{k-m};
        else
            % Bot is the smaller part
            sd{k} = Top{k-m};
        end
    end
end

