function sd = Cut3vectorized(d)
% d is a one-dimensional cell array whose length is a multiple of 4.
% sd is the cell array after cutting the deck by taking half the cards from 
%   the middle of the deck and putting that half on top.


n = length(d);
m = n/4;

sd = cell(1,n);
sd(1:2*m)=d(m+1:3*m);
sd(2*m+1:3*m)=d(1:m);
sd(3*m+1:4*m)=d(3*m+1:4*m);
