function sd = Cut3(d)
% d is a one-dimensional cell array whose length is a multiple of 4.
% sd is the cell array after cutting the deck by taking half the cards from 
%   the middle of the deck and putting that half on top.


n = length(d);
m = n/4;

sd = cell(1,n);
% new top half of the deck
  for k= 1:2*m
      sd{k}= d{m+k};
  end
% new bottom half of the deck
  for k= 1:m
      sd{2*m+k}= d{k};
      sd{3*m+k}= d{3*m+k};
  end
