// initializer lists and anonymous arrays

// you can only use initializer lists as
// + a single statement combining declaration and initialization
// + as part of an anonymous array


public class initlist0 {
    public static void main(String[] args) {

	//---------------------------------------------------------------------
	// long form
    	//---------------------------------------------------------------------
	   int[] a1;         // declare
	   a1 = new int[2];  // instantiate
	   a1[0] = 1;        // store 1st value
	   a1[1] = 2;        // store 2nd value
	   System.out.println("a1[0]: " + a1[0]);
	   System.out.println("a1[1]: " + a1[1]);
        //---------------------------------------------------------------------
	// shortcut
	//---------------------------------------------------------------------
	   int[] a2 = new int[2]; // declare and create
	   a2[0] = 1;             // store 1st value
	   a2[1] = 2;             // store 2nd value
	   System.out.println("a2[0]: " + a2[0]);
	   System.out.println("a2[1]: " + a2[1]);
	//---------------------------------------------------------------------
	// anonymous array (long form of initializer list)
	//---------------------------------------------------------------------
	   int[] a3 = new int[] {1, 2};
	   System.out.println("a3[0]: " + a3[0]);
	   System.out.println("a3[1]: " + a3[1]);
	//---------------------------------------------------------------------
	// initializer list (short cut)
	//---------------------------------------------------------------------
	   int[] a4 = {1, 2};
	   System.out.println("a4[0]: " + a4[0]);
	   System.out.println("a4[1]: " + a4[1]);

    }


}
