// things that usually go wrong with arrays

public class array_problems{
    public static void main(String args[]) {
	
	// Declare array:
	int[] a = new int[7];
	
	// Do not say:
	//     int[a] = new int[]
	//     int[] = new int[a]
	//     int[] = a[]
	
	// Store values the long way
	a[0] = 7;
	a[1] = -1;
	a[2] = 2;
	a[3] = 3;
	a[4] = 0;
	a[5] = 1;
	a[6] = 4;
	
	// Do not say:
	//     a[-1] = value
	//     a[7] (array starts at 0 and ends at 6!)
	//     an assignment backwards, like 7 = a[0]
	

	/******************
	 * OTHER PROBLEMS *
	 ******************/
	
	//==================================================//
	// MISTAKE #1                                       //
	//==================================================//
	// Try to reassign $a$
	// Once assigned, an array cannot be reassigned
	// The following code won't compile!
	/****************************/
	// double[] a = new double[];
	/****************************/
	
	//==================================================//
	// MISTAKE #2					    //
	//==================================================//
	// Try to change $a$'s size
	// This fails too because Java thinks you're
	// still trying to reassign $a$!
	/****************************/
	// int[] a = new int[10];
	/****************************/
	
	//==================================================//
	// MISTAKE #3					    //
	//==================================================//
	// Try to reassign an assigned array using an 
	// initializer list. This fails too because Java 
	// knows you're still trying to reassign $a$!
	/****************************/
	// int[] a = {0, 1, 2, 3, 4, 5, 6};
	/****************************/
	// Give it up! You cannot reassign an array

	//==================================================//
	// MISTAKE #4					    //
	//==================================================//
	// Try to use an initializer list in statement
	// w/o a declaration. You must declare and assign
	// an initializer list in the SAME statement:
	/****************************/
	// int[] x;
	// x = {0, 1, 2, 3, 4, 5, 6};
	/****************************/
	
	//==================================================//
	// MISTAKE #5					    //
	//==================================================//
	// Try to store a value beyond
	// an array's limits/dimension
	/****************************/
	// a[8] = 14;
	/****************************/
	// this code will compile but won't run:
	// Java told me "java.lang.ArrayIndexOutOfBoundsException: 8
	//                      at array2.main(Compiled Code)"
	
	//==================================================//
	// MISTAKE #6					    //
	//==================================================//
	// Try to access element that's outside of bounds
	/****************************/
	// System.out.println(a[10]);
	/****************************/
	// this code will compile but won't run:
	// Java told me "java.lang.ArrayIndexOutOfBoundsException: 10
	//                      at array2.main(Compiled Code)"
	
	//===================================================//
	// MISTAKE #7					     //
	//===================================================//
	// Try to access what you think is the last element of a
	// don't forget, you assign 7 elements to a:
	/****************************/
	// System.out.println(a[7]);
	/****************************/
	// this code will compile but won't run:
	// Java told me "java.lang.ArrayIndexOutOfBoundsException: 7
	//                      at array2.main(Compiled Code)"
	// Bzzzzz! Java starts the index from zero!!!
	// So, the last element is a[6], and NOT a[7]

	//===================================================//
	// MISTAKE #8					     //
	//===================================================//
	// Forgetting to create objects in an array of objects.
	/****************************/
	// Data[] d = new Data[3];
	// System.out.println(d[0].x);
	/****************************/
	// What you need to do is $d[0]=new Data()$ before you
	// may access $d[0]$. Why? The initial value of $d[0]$
	// is $null$!
	
    } // method main
    
} // class array_problems

// need the following class for MISTAKE #8:
class Data {public int x;}




