// array of arrays
// row major vs col major

public class aoa4 {
    public static void main(String[] args) {
	
	//---------------------------------------------------------------------
	// Want to store the following matrix/table/2-D array:
	// 1 2 3
	// 4 5 6
	//---------------------------------------------------------------------
	
	//---------------------------------------------------------------------
	// Row major:
	// A = [row 0] = [1 2 3]
	//     [row 1]   [4 5 6]
	//---------------------------------------------------------------------
	
	int[][] A = new int[2][3];          // 2 rows, 3 cols
	
	A[0][0]=1;  A[0][1]=2;  A[0][2]=3;  // 1st row
	A[1][0]=4;  A[1][1]=5;  A[1][2]=6;  // 2nd row
	
	print_rm("Row Major",A);            // print matrix
	
	//---------------------------------------------------------------------
	// Alternative with initializer lists:
	// int A[][]  = { {1,2,3}, {4,5,6} };
	//---------------------------------------------------------------------
	
	//---------------------------------------------------------------------
	// Col major:
	// B = [col0 col1 col2]
	//   =   [1]  [2]  [3]
	//       [4]  [5]  [6]
	//---------------------------------------------------------------------
	
	int[][] B = new int[3][2];          // 3 cols, 2 rows
	
	B[0][0]=1;  B[1][0]=2;  B[2][0]=3;  // first "row"
	B[0][1]=4;  B[1][1]=5;  B[2][1]=6;  // second "row"
	
	print_cm("Col Major",B);            // print matrix
	
	//---------------------------------------------------------------------
	// Alternative with initializer lists:
	// int[][] B = { {1,4}, {2,5}, {3,6} };
	//---------------------------------------------------------------------
	
    } // method main
    
    public static void print_rm(String s, int[][] x) {
	
	System.out.println(s);
	
	for (int i=0; i<x.length; i++) {
	    for (int j=0; j<x[i].length; j++) 
		System.out.print(x[i][j] + " ");
	    System.out.println();
	}
	
    } // method print_rm
    
    public static void print_cm(String s, int[][] x) {
	System.out.println(s);
	// should find max "Depth! Instead I'll use the easy way out
	// and assume that all columns have the same depth:
	for (int j=0; j<x[0].length; j++) {      // loop over each row j
	    for (int i=0; i<x.length; i++)       // loop over each col i
		System.out.print(x[i][j] + " "); // print elem at col i, row j
	    System.out.println();
	}
	
    } // method print_cm
} // class aoa4

/* output:

   Row Major
   1 2 3 
   4 5 6 
   Col Major
   1 2 3 
   4 5 6 

*/
