// more about array of arrays
// show different ways of declaring and creating

public class aoa1 {
    public static void main(String[] args) {
        
        //---------------------------------------------------------------------
        // equivalent ways to declare "2-D arrays", i.e. arrays of arrays
        int[][] x; // x is an array of arrays of ints
        int[] y[]; // y is an array whose elements are arrays of ints
        int z[][]; // z is an array of arrays whose elements are ints
        
        // create x
        x = new int[2][2];

        //---------------------------------------------------------------------
        //   Box diagram for x
        //   note: left out main method box
        //
        // +--------+ +--------------------+
        // |        | |          +---+---+ |
        // |  +---+ | |  +----+  | 0 | 0 | |
        // | x| *-+-+-+->|  *-+->+---+---+ |
        // |  +---+ | |  +----+            |
        // |        | |  |  *-+->+---+---+ |
        // |        | |  +----+  | 0 | 0 | |
        // |        | |          +---+---+ |
        // +--------+ +--------------------+
        // Main Class       int[] Class
        //
        //---------------------------------------------------------------------

        // create y
        // stage 1: create  
        y = new int[2][]; 

        //---------------------------------------------------------------------
        // Box diagram for y
        //
        // +--------+ +--------------------+
        // |  +---+ | |  +----+            |
        // | y| *-+-+-+->|null|            |
        // |  +---+ | |  +----+            |
        // |        | |  |null|            |
        // |        | |  +----+            |
        // +--------+ +--------------------+
        // Main Class    int[] Class
        //---------------------------------------------------------------------
        
        y[0] = new int[2]; 

        //---------------------------------------------------------------------
        // Box diagram for y
        //
        // +--------+ +--------------------+
        // |        | |          +---+---+ |
        // |  +---+ | |  +----+  | 0 | 0 | |
        // | y| *-+-+-+->|  *-+->+---+---+ |
        // |  +---+ | |  +----+            |
        // |        | |  |null|            |
        // |        | |  +----+            |
        // +--------+ +--------------------+
        // Main Class    int[] Class
        //---------------------------------------------------------------------

        y[1] = new int[2];

        //---------------------------------------------------------------------
        // Box diagram for y
        //
        // +--------+ +--------------------+
        // | 	    | |          +---+---+ |
        // |  +---+ | |  +----+  | 0 | 0 | |
        // | y| *-+-+-+->|  *-+->+---+---+ |
        // |  +---+ | |  +----+            |
        // | 	    | |  |  *-+->+---+---+ |
        // | 	    | |  +----+  | 0 | 0 | |
        // | 	    | |          +---+---+ |
        // +--------+ +--------------------+
        // Main Class    int[] Class
        //---------------------------------------------------------------------

        z = new int[][] { { 2, 3}, { 3, 4} };

        //---------------------------------------------------------------------
        // Box diagram for z
        //
        // +--------+ +-----------------------+
        // |        | |          +---+---+    |
        // |  +---+ | |  +----+  | 2 | 3 |    |
        // | z| *-+-+-+->|  *-+->+---+---+    |
        // |  +---+ | |  +----+               |
        // |        | |  |  *-+->+---+---+    |
        // |        | |  +----+  | 3 | 4 |    |
        // |        | |          +---+---+    |
        // +--------+ +-----------------------+
        // Main Class    int[] Class
        //---------------------------------------------------------------------
 
// ok to assign new values -- haven't declared twice!
// observe that the old array is still (temporarily) around
// (we could have used 2, 3, 3, 4 again, but used 12, 13, 13, 14 for clarity)

        z = new int[][] { new int[] { 12, 13}, new int[] { 13, 14} };

        //---------------------------------------------------------------------
        // Box diagram for y
        //
        // +--------+ +-----------------------+
        // |        | |          +---+---+    |
        // |  +---+ | |  +----+  | 2 | 3 |    |
        // | z| * | | |  |  *-+->+---+---+    |
        // |  +-+-+ | |  +----+               |
        // |    |   | |  |  *-+->+---+---+    |
        // |    |   | |  +----+  | 3 | 4 |    |
        // |    |   | |          +---+---+    |
        // |    |   | |                       |
        // |    |   | |          +----+----+  |
        // |    +---+-+->+----+  | 12 | 13 |  |
        // |        | |  |  *-+->+----+----+  |
        // |        | |  +----+               |
        // |        | |  |  *-+->+----+----+  |
        // |        | |  +----+  | 13 | 14 |  |
        // |        | |          +----+----+  |
        // +--------+ +-----------------------+
        // Main Class    int[] Class
        //---------------------------------------------------------------------

    }

}

