public class Problem3 {

    public static final int MAXBITS = 8*randInt(1,5); // # of bits in sim
    public static String sequence = "";               // seq of bits generated in sim
    public static int maxOnes;                        // max number of 1s in sim
    
    // Run program:
    public static void main(String[] args) {
	runSim(); // run one simulation to set sequence and maxOnes
	System.out.println("Sequence: " + sequence );
	System.out.println("Maximum sequence of 1s: " + maxOnes);
    }	
    
    // Return a random integer (LOW <= integer <= HIGH):
    public static int randInt(int low, int high) {
	if (low > high) System.exit(0);
	return (int) (Math.random()*(high-low+1))+(int)low;
    }
    
    // Return a random bit (0 or 1):	
    public static int randBit() {
	return randInt(0,1);
    }

    // Run the simulation, which updates the sequence of bits (sequence) 
    // and determines the max sequence of 1s (maxOnes):
    public static void runSim() {
	int oneCounter = 0 ; // count of 1s so far
        for(int count=1;count<=MAXBITS;count++) {
            int nextBit = randBit();
            if (nextBit==1) oneCounter++; 
	    else oneCounter = 0;
            if (oneCounter>maxOnes) maxOnes=oneCounter;
            sequence+=nextBit;
        }
    }
}
