/* CS 100 Assignment 6 Solution PuzzleAsArray
 * adapting code from Kiri Wagstaff
 * Modified by Rachel
*/

import java.util.Stack;

public class PuzzleAsString implements IPuzzle
{

	private char BLANK = ' '; // representation of blank tile (0)
	private int SIZE; // size of puzzle
	private int END; // size*size-1 (lastIndex)
	private String puzzle; // string of "tiles"
	private int blankPos; // location of blank tile
	private int level; // level of scambling puzzle  
	private Stack moves = new Stack();

	// Create a 3x3 puzzle
	// Originally we created a tile size SIZE and set params accordingly:
	public void autoSolve()
	{
		while (!moves.empty() && !isSolved())
		{
			char dir = ((Character) (moves.pop())).charValue();
			char opdir = ' ';
			switch (dir)
			{
				case 'N' :
					opdir = 'S';
					break;
				case 'S' :
					opdir = 'N';
					break;
				case 'W' :
					opdir = 'E';
					break;
				case 'E' :
					opdir = 'W';
					break;
			}
			autoMove(opdir);
			display();
			for(int i = 0; i < 300000000; i++)
			{
			}	
		}
	}
	public PuzzleAsString(int level, int size)
	{
		setDifficulty(level);
		setPuzzleDims(size);
		createPuzzle();
	}

	// Set difficulty (how much puzzle is scrambled):
	private void setDifficulty(int level)
	{
		this.level = level;
	}

	// Set border index values for puzzle:
	private void setPuzzleDims(int size)
	{
		SIZE = size;
		END = size * size - 1;
	}

	// Create initial puzzle with an array and reset it:
	private void createPuzzle()
	{
		resetPuzzle();
	}

	// Restore puzzle to initial state:
	public void resetPuzzle()
	{
		// Fill current puzzle:
		puzzle = createTileString();

		// Set location of blank tile:
		blankPos = END;
	}

	// Create a string of numbers:
	private String createTileString()
	{
		// "Fill" puzzle with ascending numbers starting from 1.
		// Work from left-to-right, then top-down:
		String tiles = "";
		for (int c = 1; c <= END; c++)
			tiles += c;
		tiles += ("" + BLANK);
		return tiles;
	}

	// Return true if puzzle is solved:
	public boolean isSolved()
	{
		return puzzle.equals(createTileString());
	}

	// Move a tile in the specified direction (dir: N/S/E/W), if possible.
	// Return true if the move was successful; otherwise, false:
	public boolean move(char dir)
	{
		char[] tiles = puzzle.toCharArray();

		switch (dir)
		{
			case 'N' :
				if ((blankPos > END - SIZE) && (blankPos <= END))
					return false; // no tile to move north
				moves.push(new Character(dir));
				// Swap the blank and what's right below it
				tiles[blankPos] = puzzle.charAt(blankPos + SIZE);
				tiles[blankPos + SIZE] = BLANK;
				blankPos = blankPos + SIZE;
				break;
			case 'S' :
				if (blankPos < SIZE)
					return false; // no tile to move south
				moves.push(new Character(dir));
				// Swap the blank and what's right above it
				tiles[blankPos] = puzzle.charAt(blankPos - SIZE);
				tiles[blankPos - SIZE] = BLANK;
				blankPos = blankPos - SIZE;
				break;
			case 'E' :
				if ((blankPos - SIZE) % SIZE == 0)
					return false; // no tile to move east
				moves.push(new Character(dir));
				// Swap the blank and what's to the left of it
				tiles[blankPos] = puzzle.charAt(blankPos - 1);
				tiles[blankPos - 1] = BLANK;
				blankPos--;
				break;
			case 'W' :
				if ((blankPos + 1) % SIZE == 0)
					return false; // no tile to move west
				moves.push(new Character(dir));
				// Swap the blank and what's to the right of it
				tiles[blankPos] = puzzle.charAt(blankPos + 1);
				tiles[blankPos + 1] = BLANK;
				blankPos++;
				break;
		}

		puzzle = new String(tiles); // reforge the String
		return true;
	}
	
	private boolean autoMove(char dir)
	{
		char[] tiles = puzzle.toCharArray();
		
		switch (dir)
		{
			case 'N' :
			tiles[blankPos] = puzzle.charAt(blankPos + SIZE);
			tiles[blankPos + SIZE] = BLANK;
			blankPos = blankPos + SIZE;
				break;
			case 'S' :
			tiles[blankPos] = puzzle.charAt(blankPos - SIZE);
			tiles[blankPos - SIZE] = BLANK;
			blankPos = blankPos - SIZE;
				break;
			case 'E' :
			tiles[blankPos] = puzzle.charAt(blankPos - 1);
			tiles[blankPos - 1] = BLANK;
			blankPos--;
				break;
			case 'W' :
			tiles[blankPos] = puzzle.charAt(blankPos + 1);
			tiles[blankPos + 1] = BLANK;
			blankPos++;
					break;
		}
		puzzle = new String(tiles); // reforge the String
		return true;
	}
	// Scrambles the puzzle by making a series of random moves:
	public void scramble()
	{
		resetPuzzle();
		int count = 0;
		while (count < level)
		{
			int m = (int) (Math.random() * 4);
			switch (m)
			{
				case 0 :
					if (move('N'))
						count++;
					break;
				case 1 :
					if (move('S'))
						count++;
					break;
				case 2 :
					if (move('E'))
						count++;
					break;
				case 3 :
					if (move('W'))
						count++;
					break;
			}
		}


	}

	// Display puzzle:
	public void display()
	{
		System.out.println(this);
	}

	// String representation of tiles:
	public String toString()
	{
		char[] tiles = puzzle.toCharArray();

		// Standard row: +-...+-...
		// assuming only size 2 or 3 to get single digits!
		String rowBorder = "+";
		for (int row = 0; row < SIZE; row++)
			rowBorder += "---+";
		rowBorder += "\n";

		// Build string that stores puzzle:
		String p = ""; // string rep of puzzle
		int pos = 0;
		for (int row = 0; row < SIZE; row++)
		{
			// Start new row:
			p += rowBorder + "|";

			// Fill in tiles:
			for (int col = 0; col < SIZE; col++)
			{
				// first padding:
				p += " ";

				// store tile number:
				p += tiles[pos];

				// last padding and column:
				p += " |";

				// update
				pos++;
			}

			// End current row:
			p += "\n";
		}

		// End puzzle:
		p += rowBorder;

		// Done!
		return p;
	}

	// Number of digits in an integer:
	private int digitCount(int num)
	{
		return ("" + num).length();
	}

} // Class PuzzleAsString
