/* CS 100 Assignment 6 Solution (PuzzleAsArray)
 * adapting code from Kiri Wagstaff
 * Modified by Rachel
*/

import java.util.Stack;

public class PuzzleAsArray implements IPuzzle
{
	private char BLANK = ' '; // representation of blank tile (0)
	private int SIZE; // size of puzzle
	private char[][] puzzle; // array of "tiles"
	private int LEFT, RIGHT; // limits of horz dimensions
	private int TOP, BOTTOM; // limits of vert dimensions
	private int blankRow, blankCol; // location of blank tile
	private int level;
	private Stack moves = new Stack();

	public void autoSolve()
	{
		while (!moves.empty() && !isSolved())
		{
			char dir = ((Character) (moves.pop())).charValue();
			char opdir = ' ';
			switch (dir)
			{
				case 'N' :
					opdir = 'S';
					break;
				case 'S' :
					opdir = 'N';
					break;
				case 'W' :
					opdir = 'E';
					break;
				case 'E' :
					opdir = 'W';
					break;
			}
			autoMove(opdir);
			display();
			for(int i = 0; i < 300000000; i++)
			{
			}	
		}
	}
	// Create an Array Puzzle:
	// Originally, create a tile size SIZE and set params accordingly:
	public PuzzleAsArray(int level, int size)
	{
		setDifficulty(level);
		setPuzzleDims(size);
		createPuzzle();
	}

	// Set difficulty (how much puzzle is scrambled):
	private void setDifficulty(int level)
	{
		this.level = level;
	}

	// Set border index values for puzzle:
	private void setPuzzleDims(int size)
	{
		SIZE = size;
		LEFT = TOP = 0;
		RIGHT = BOTTOM = size - 1;
	}

	// Create initial puzzle with an array and reset it:
	private void createPuzzle()
	{
		puzzle = new char[SIZE][SIZE];
		resetPuzzle();
	}

	// Restore puzzle to initial state:
	public void resetPuzzle()
	{
		// Fill puzzle with ascending numbers starting from 1.
		// Work from left-to-right, then top-down:
		int count = 1;
		for (int row = 0; row < SIZE; row++)
			for (int col = 0; col < SIZE; col++)
				puzzle[row][col] = (char) ('0' + count++);

		// Set location of blank tile:
		blankRow = BOTTOM;
		blankCol = RIGHT;
		puzzle[blankRow][blankCol] = BLANK;
	}

	// Return true if puzzle is solved:
	public boolean isSolved()
	{
		// Are values inside the array OK?
		int count = 1;
		for (int row = 0; row < SIZE; row++)
			for (int col = 0; col < SIZE; col++)
			{
				if (puzzle[row][col] != (char) ('0' + count))
					if (puzzle[row][col] != BLANK
						|| // not counting blank (0) in count++
					puzzle[BOTTOM][RIGHT]
							!= BLANK)
						// something else is in blank tile starting position!
						return false;
				count++;
			}

		return true;
	}

	// Move a tile in the specified direction (dir: N/S/E/W), if possible.
	// Return true if the move was successful; otherwise, false:
	public boolean move(char dir)
	{
		switch (dir)
		{
			case 'N' :
				if (blankRow == BOTTOM)
					return false; // no tile to move north
				moves.push(new Character(dir));
				// Swap the blank and what's right below it
				puzzle[blankRow][blankCol] = puzzle[blankRow + 1][blankCol];
				puzzle[blankRow + 1][blankCol] = BLANK;
				blankRow++;
				break;
			case 'S' :
				if (blankRow == TOP)
					return false; // no tile to move south
				moves.push(new Character(dir));
				// Swap the blank and what's right above it
				puzzle[blankRow][blankCol] = puzzle[blankRow - 1][blankCol];
				puzzle[blankRow - 1][blankCol] = BLANK;
				blankRow--;
				break;
			case 'E' :
				if (blankCol == LEFT)
					return false; // no tile to move east
				moves.push(new Character(dir));
				// Swap the blank and what's to the left of it
				puzzle[blankRow][blankCol] = puzzle[blankRow][blankCol - 1];
				puzzle[blankRow][blankCol - 1] = BLANK;
				blankCol--;
				break;
			case 'W' :
				if (blankCol == RIGHT)
					return false; // no tile to move west
				moves.push(new Character(dir));
				// Swap the blank and what's to the right of it
				puzzle[blankRow][blankCol] = puzzle[blankRow][blankCol + 1];
				puzzle[blankRow][blankCol + 1] = BLANK;
				blankCol++;
				break;
		}
		return true;
	}

	private boolean autoMove(char dir)
	{
		switch (dir)
		{
			case 'N' :
				puzzle[blankRow][blankCol] = puzzle[blankRow + 1][blankCol];
				puzzle[blankRow + 1][blankCol] = BLANK;
				blankRow++;
				break;
			case 'S' :
				puzzle[blankRow][blankCol] = puzzle[blankRow - 1][blankCol];
				puzzle[blankRow - 1][blankCol] = BLANK;
				blankRow--;
				break;
			case 'E' :
				puzzle[blankRow][blankCol] = puzzle[blankRow][blankCol - 1];
				puzzle[blankRow][blankCol - 1] = BLANK;
				blankCol--;
				break;
			case 'W' :
				puzzle[blankRow][blankCol] = puzzle[blankRow][blankCol + 1];
				puzzle[blankRow][blankCol + 1] = BLANK;
				blankCol++;
				break;
		}
		return true;
	}

	// Scrambles the puzzle by making a series of random moves:
	public void scramble()
	{
		resetPuzzle();
		int count = 0;
		while (count < level)
		{
			int m = (int) (Math.random() * 4);
			switch (m)
			{
				case 0 :
					if (move('N'))
						count++;
					break;
				case 1 :
					if (move('S'))
						count++;
					break;
				case 2 :
					if (move('E'))
						count++;
					break;
				case 3 :
					if (move('W'))
						count++;
					break;
			}
		}

	}

	// Display puzzle:
	public void display()
	{
		System.out.println(this);
	}

	// String representation of tiles:
	public String toString()
	{
		// Create row based on # of largest digits (size^2-1)
		// Each time print a number, print # of spaces less than max digits
		// Standard row: +-...+-...
		final int MAXSIZE = digitCount(SIZE * SIZE - 1);
		// number of digits in largest tile #
		String rowBorder = "+"; // start of row border
		for (int row = 0; row < SIZE; row++)
		{
			rowBorder += "-"; // leave one empty space for padding
			for (int s = 0; s < MAXSIZE; s++)
				rowBorder += "-"; // enough spaces to handle largest number
			rowBorder += "-+";
			// leave one empty space for padding and put "+" for col
		}
		rowBorder += "\n"; // end of row border

		// Build string that stores puzzle:
		// - rowborder then row and repeat; end with rowborder
		// - for a row,
		//   print |, space, number, enough space to pad number with max digits, space, repeat; end with |

		// Build row with tiles:
		String p = ""; // string rep of puzzle

		for (int row = 0; row < SIZE; row++)
		{
			// Start new row:
			p += rowBorder + "|";

			// Fill in tiles:
			for (int col = 0; col < SIZE; col++)
			{
				// first padding:
				p += " ";

				// internal padding for right-alignment:
				int tileSize = digitCount(puzzle[row][col]);
				for (int s = 0; s < MAXSIZE - tileSize; s++)
					p += " ";

				// store tile number:
				p += puzzle[row][col];

				// last padding and column:
				p += " |";
			}
			// End current row:
			p += "\n";
		}
		// End puzzle:
		p += rowBorder;

		// Done!
		return p;
	}

	// Number of digits in an integer:
	private int digitCount(int num)
	{
		return ("" + num).length();
	}

} // Class PuzzleAsArray
