import java.io.*;

public class PlayPuzzle
{

	public static String type = "array";
	public static boolean playAgain = true;
	public static int moves;
	public static int level = 3;
	public static int size = 3;
	public static BufferedReader in =
		new BufferedReader(new InputStreamReader(System.in));
	public static IPuzzle puzzle;

	// Play 3x3 game:
	public static void main(String[] args)
	{
		setGameParameters(args); // user's game settings
		welcomeUser(); // say hello
		playGame(); // single game play
	}

	// Change game settings:
	private static void setGameParameters(String[] args)
	{
		// Get type commandline; default type is array if nothing entered:
		if (args.length > 0)
		{
			if (args.length == 3)
			{
				type = args[0];
				if (!type.equals("array") && !type.equals("string"))
				{
					System.out.println("Type of puzzle (" + type + ") not recognized!");
					System.exit(0);
				}
				level = Integer.parseInt(args[1]);
				if (level < 0)
				{
					System.out.println("level cannot be negative");
					System.exit(0);
				}
				size = Integer.parseInt(args[2]);
				if (size < 2 || size > 3)
				{
					System.out.println("size should be 2 or 3");
					System.exit(0);
				}
			}
			else
			{
				System.out.println(
					"Please include 3 arguments: type, level, number");
				System.out.println("or no argument to use default setting.");
				System.exit(0);
			}
		}
	}

	// Welcome the user:
	private static void welcomeUser()
	{
		System.out.println("Welcome to Puzzle!");
		System.out.println();
	}

	// Play one game:
	private static void playGame()
	{

		// Create the puzzle:
		if (type.equals("array"))
			puzzle = new PuzzleAsArray(level, size);
		else if (type.equals("string"))
			puzzle = new PuzzleAsString(level, size);

		// Scramble the puzzle:
		puzzle.scramble();

		// Show current state:
		System.out.println("Current state of puzzle:");
		puzzle.display();

		// Make tile moves until the puzzle is solved:
		while (!puzzle.isSolved())
		{
			System.out.println("The puzzle isn't solved yet.");

			// Move a tile into the blank space and test the puzzle again:
			char tryMove = getMove();
			while (!puzzle.move(tryMove))
			{
				System.out.println("You cannot move a tile in that direction.");
				tryMove = getMove();

			}

			// Keep track of valid moves made:
			moves++;

			// Show current state:
			System.out.println("Current state of puzzle:");
			puzzle.display();
		}

		// Done!
		System.out.println("Congratulations!");
		System.out.println("Number of moves you took: " + moves + ".");

	}

	// Get a character move:
	private static char getMove()
	{

		// Get user input:
		char move = ' ';
		String user1, user2;
		try
		{
			System.out.print("Input [NSEW QRA?]> ");
			move = ((in.readLine()).toUpperCase()).charAt(0);

			while (!(move == 'N' || move == 'S' || move == 'E' || move == 'W'))
			{
				if (move == 'Q')
				{
					System.out.println("Quitting!");
					System.exit(0);
				}
				else if (move == 'R')
				{
					playGame();
					System.exit(0);
				}
				else if (move == 'A')
				{
					puzzle.autoSolve();
					System.exit(0);
				}
				if (move == '?')
				{
					System.out.println("N: move North");
					System.out.println("S: move South");
					System.out.println("E: move East");
					System.out.println("W: move West");
					System.out.println("Q: Quit the game immediately");
					System.out.println(
						"R: Restart the game by re-scrambling the Puzzle");
					System.out.println(
						"A: Automatically solve the Puzzle from the current state.");
					System.out.println(
						"?: Help! Display an explanation of these input selections.");
				}
				else
				{
					System.out.println("Invalid input");
				}
				System.out.println("Input [NSEW QRA?]> ");

				move = ((in.readLine()).toUpperCase()).charAt(0);
			}

		}
		catch (Exception e)
		{
			System.out.println("Quitting!");
			System.exit(0);
		}

		System.out.println();
		return move;
	}

} // Class PlayPuzzle
