//-----------------------------------------------------------------------------
//Problem2b solution
//-----------------------------------------------------------------------------
// Useful class for random method:
import java.io.*;
class MyMath {
    
    // Return a random integer between low and high:
    public static int myRandom(int low, int high) {
        return (int) (Math.random()*(high-low+1)) + (int) low;
    }
    
} // Class MyMath
//-----------------------------------------------------------------------------
// Truck holds boxes that are reported:
class Truck {
    private boolean full = false;
    private int boxes; // amount of boxes on Truck
    public static final int CAPACITY = 100;
    public void addBoxes(int boxes) { 
        if(this.boxes + boxes < CAPACITY)
            this.boxes += boxes; 
        else 
        {
            this.boxes = CAPACITY;
            full = true;
        }
    }
    public boolean isFull(){return full;}
    public int getBoxes() { return boxes; }
    
} // Class Truck
//-----------------------------------------------------------------------------
// Chute spews boxes:
class Chute {
    
    public static final int LOW  = 2; // smallest amount of boxes spewed
    public static final int HIGH = 4; // largest amount of boxes spewed
    
    // Return a random amount of boxes spewed forth from Chute:
    public int spewBoxes() { return MyMath.myRandom(LOW,HIGH); }
    
} // Class Chute
//-----------------------------------------------------------------------------
// Bin holds boxes that are spewed from Chute:
class Bin {
    
    private int boxes;
    public static final int MAXBOXES = 20; // max amount of boxes bin holds
    public void addBoxes(int boxes) { this.boxes += boxes; }
    public void removeBoxes(int boxes) { this.boxes -= boxes; }
    public void resetBoxes() { boxes=0; }
    public int getBoxes() { return boxes; }
    public boolean binIsExceeded (int boxesToAdd) {
        return (boxes+boxesToAdd) > MAXBOXES;
    }
    
} // Class Bin
//-----------------------------------------------------------------------------
// Worker takes boxes from Bin and puts them in the Truck:
class Worker {
    private String name;                    // Worker's name
    private double initialEfficiency=1;     // baseline efficiency
    private double currentEfficiency=       // updated efficiency
        initialEfficiency;
    public static final int CYCLECOUNT = 4; // cycles to reduce efficiency
    private double efficiencyFactor = 1-0.15; // amount to factor efficiency
    public static final int LOW = 1;        // min boxes Worker carries
    public static final int HIGH = 4;       // max boxes Worker carries
    
    // Create a Worker with id and name:
    public Worker(String name) {
        this.name = name;
    }
    
    // Amount of boxes Worker is current able to extract:
    public int extractBoxes() { 
        return  (int) (currentEfficiency*MyMath.myRandom(LOW,HIGH));
    }
    
    // Reduce efficiency:
    public void reduceEfficiency(int currentCycles) {
        if (currentCycles % CYCLECOUNT == 0)
            currentEfficiency *= efficiencyFactor;
    }
    
} // Class Worker
//-----------------------------------------------------------------------------
// Class to run simulation:
public class Problem2b {
    
    
    public static void main(String[] args) 
    {
        int simuTimes;
        if (args.length > 0)
            simuTimes = Integer.parseInt(args[0]);
        else 
        {
            System.out.println("How many times you want to simulate?");
            simuTimes = SavitchIn.readInt();
        }
        int minBoxes = Truck.CAPACITY;
        int maxBoxes = 0;
        int avgBoxes = 0;
        int avgCycles = 0;
        PrintWriter outputStream = null;
        try{
            outputStream = new PrintWriter(new FileOutputStream("Problem2b.data"));
        }
        catch(FileNotFoundException e)
        {
            System.out.println("Erro opening");
            System.exit(0);
        }
        for(int times = 0; times < simuTimes; times++)
        {
            // Create three Workers:        
            Worker worker[] = new Worker[3];
            worker[0] = new Worker("Sam");
            worker[1] = new Worker("Pat");
            worker[2] = new Worker("Joe");
            
            
            // Create Chute to spew boxes:
            Chute chute1 = new Chute();
            
            // Bin holds boxes the spew from Chute:
            Bin bin1 = new Bin();
            
            // Truck holds boxes that Workers carry from Bin:
            Truck truck1 = new Truck();
            
            // Run Simulation:
            
            // Cycles of Workers so far
            int cycles = 0;                       
            
            // Proposed amount of boxes to add to Bin
            int boxesToAdd = chute1.spewBoxes();
            
            // Attempt to add current boxes. If the bin has not
            // maxed out, add the boxes. Workers will attempt to remove
            // boxes and put them in truck. Stop when Bin is exceeded:
            
            while (!bin1.binIsExceeded(boxesToAdd) && !truck1.isFull()) {
                
                cycles++;                  // increment cycle count
                bin1.addBoxes(boxesToAdd); // put the boxes in Bin
                
                // Attempt to take boxes from Bin
                for(int i = 0; i < 3; i++)
                    takeBoxesFromBin(worker[i], bin1, truck1);
                
                // Reduce Workers' efficiencies:
                for(int i = 0; i < 3; i++)
                    worker[i].reduceEfficiency(cycles);
                
                // Obtain more boxes from chute
                boxesToAdd = chute1.spewBoxes();            
            } // end while
            
            // Report results:
            int truckBoxes = truck1.getBoxes();
            outputStream.println(times + " " + truckBoxes + " " + cycles);
            System.out.println("Simulation NO."+ times);
            System.out.println("Final boxes on Truck:\t" + 
                               truckBoxes);
            System.out.println("Count of cycles:\t"      + cycles);
            minBoxes = (truckBoxes < minBoxes)? truckBoxes:minBoxes;
            maxBoxes = (truckBoxes > maxBoxes)? truckBoxes:maxBoxes;
            avgBoxes += truckBoxes;
            avgCycles += cycles;
        }
        outputStream.close();
        avgBoxes /= simuTimes;
        avgCycles /= simuTimes;
        System.out.println("Average number of boxes placed in the truck:\t" + avgBoxes);
        System.out.println("Minimum number of boxes placed in the truck:\t" + minBoxes);
        System.out.println("Maximum number of boxes placed in the truck:\t" + maxBoxes);
        System.out.println("Average number of completed cycles:\t" + avgCycles);
    } // method main
    
    // Attempt to remove boxes from Bin by a Worker:
    private static void takeBoxesFromBin(Worker w, Bin bin1, Truck truck1) { 
        
        int boxesTaken = w.extractBoxes();
        if (boxesTaken <= bin1.getBoxes()) {
            truck1.addBoxes(boxesTaken);
            bin1.removeBoxes(boxesTaken);
        } else {
            truck1.addBoxes(bin1.getBoxes());
            bin1.resetBoxes();
        }
        
    } // method takeBoxesFromBin
    
} 
//-----------------------------------------------------------------------------
