public class Problem2a
{
    public static final int BIN_MAXBOXES = 20;
    public static final int TRUCK_CAPACITY = 100;
    public static final int SPEW_MIN = 2;
    public static final int SPEW_MAX = 4;
    public static final int ABILITY_MIN = 1;
    public static final int ABILITY_MAX = 4;
    
    public static void main(String[] args)
    {
        // Cycles of Workers so far
        int cycles = 0;                       
        int binBoxes = 0;
        int truckBoxes = 0;
        double efficiency = 1;
        // Proposed amount of boxes to add to Bin
        int boxesToAdd = myRandom(SPEW_MIN, SPEW_MAX);
        int boxesToTake = 0;
        
        // Attempt to add current boxes. If the bin has not
        // maxed out, add the boxes. Workers will attempt to remove
        // boxes and put them in truck. Stop when Bin is exceeded:
        while (binBoxes + boxesToAdd <= BIN_MAXBOXES && truckBoxes < TRUCK_CAPACITY) {
            
            cycles++;                  // increment cycle count
            binBoxes = binBoxes + boxesToAdd; // put the boxes in Bin
            
            // Attempt to take boxes from Bin
            for(int i = 0; i < 3; i++)   //3 workers
            {
                boxesToTake = takeBoxesFromBin(efficiency, binBoxes);
                binBoxes -= boxesToTake;
                if(truckBoxes + boxesToTake < TRUCK_CAPACITY) 
                    truckBoxes += boxesToTake;
                else truckBoxes = TRUCK_CAPACITY;
            }
            
            // Reduce Workers' efficiencies:
            if(cycles % 4 == 0)
                efficiency *= (1-0.15);
            
            // Obtain more boxes from chute
            boxesToAdd = myRandom(SPEW_MIN, SPEW_MAX);            
        } // end while
        
        // Report results:
        System.out.println("Final boxes on Truck:\t" + 
                           truckBoxes);
        System.out.println("Count of cycles:\t"      + cycles);
    }
    
    static int myRandom(int low, int high) 
    {
        return (int) (Math.random()*(high-low+1)) + (int) low;
    }
    
    static int takeBoxesFromBin(double efficiency, int binBoxes) 
    { 
        
        int boxesTaken = (int) (efficiency * myRandom(ABILITY_MIN, ABILITY_MAX));
        if (boxesTaken <= binBoxes) 
        {
            return boxesTaken;
        } else {
            return binBoxes;
        }
        
    } // method takeBoxesFromBin
    
}