/**
 * Problem1.java
 * Description: This is the source for cs100m A5 Task1
 * @author Daniel Chen (cc247)
 * version: 4/5/04
 */
class Problem1 {
  public static void testComparisions(Temperature t1, Temperature t2) {
    System.out.println("Comparing t1 " + t1 + " and t2 " + t2);
    System.out.println("t1 Celsius= " + t1.getCelsius()+" Fahrenheit=" + t1.getFahrenheit());
    System.out.println("t2 Celsius= " + t2.getCelsius()+" Fahrenheit=" + t2.getFahrenheit());
    // compareTo
    System.out.println("compareTo(): " + t1.compareTo(t2));
    // isGreaterthan
    System.out.println("isGreaterThan(): " + t1.isGreaterThan(t2));
    // ieLessThan
    System.out.println("isLessThan(): " + t1.isLessThan(t2));

  }

  public static void main(String[] args) {

    Temperature[] tArray = new Temperature[8];
    // Testing the constructors
    tArray[0] = new Temperature();
    tArray[1] = new Temperature(32,'F');
    tArray[2] = new Temperature( -40, 'C');
    tArray[3] = new Temperature( -40, 'F');
    tArray[4] = new Temperature(100);
    tArray[5] = new Temperature(212, 'F');
    tArray[6] = new Temperature ('F');
    tArray[7] = new Temperature (100,'C');

    //Testing Comparison and accessor methods
   for (int i =0; i< 4;i++) {
     testComparisions(tArray[i*2],tArray[i*2+1]);
   }
    //Testing reset methods
    tArray[3].reset();
    System.out.println(tArray[3]);
    tArray[4].resetType();
    System.out.println(tArray[4]);
    tArray[5].resetValue();
    System.out.println(tArray[5]);
  }
}

class Temperature {
  private static final char CELSIUS = 'C';
  private static final char FAHRENHEIT = 'F';
  private static final double DEFAULT_DEGREE = 0.0;
  private static final char DEFAULT_TYPE = CELSIUS;
  private double value; // temperature value
  private char type; // either 'C' for Celsius or 'F' for Fahrenheith

  // Constructor 1: default constructor
  public Temperature() {
    value = DEFAULT_DEGREE;
    type = DEFAULT_TYPE;
  }

  // Constructor 2 : only value is specified
  public Temperature(double value) {
    this.value = value;
    type = DEFAULT_TYPE;
  }

  // Constructor 3: only type is specified
  public Temperature(char type) {
    this.value = DEFAULT_DEGREE;
    if (checkType(type)) {
      this.type = type;
    }
    else {
      System.out.println("Bad type value. Default type: " + DEFAULT_TYPE +
                         " is used.");
      this.type = DEFAULT_TYPE;
    }
  }

  // Constructor 4
  public Temperature(double value, char type) {
    this.value = value;
    if (checkType(type)) {
      this.type = type;
    }
    else {
      System.out.println("Bad type value. Default type: " + DEFAULT_TYPE +
                         " is used.");
      this.type = DEFAULT_TYPE;
    }
  }

  // accessors

  // get the temperature in Celsius
  public double getCelsius() {
    if (type == CELSIUS)
      return value;
    else
      return round(5 * (value - 32) / 9);

  }

  // get the temperature in Fahrenheit
  public double getFahrenheit() {
    if (type == FAHRENHEIT)
      return value;
    else
      return round(9 * value / 5 + 32);
  }

  // reset methods

  public void resetValue() {
    // reset value to 0
    this.value = DEFAULT_DEGREE;
  }

  public void resetValue(double value) {
    this.value = value;
  }


  public void resetType() {
    // reset type back to default
    this.type = DEFAULT_TYPE;
  }
  public void resetType(char type) {
    if (checkType(type)) {
      this.type = type;
    }
    else {
      System.out.println("Bad type value. Default type: " + DEFAULT_TYPE +
                         " is used.");
      this.type = DEFAULT_TYPE;
    }

  }


  // reset both parameters
  public void reset() {
    resetValue();
    resetType();
  }
  public void reset(double value,char type) {
    resetValue(value);
    resetType(type);
  }

  // compare methods

  public int compareTo(Temperature otherT) {
    return Double.compare(this.getCelsius(), otherT.getCelsius());
  }

  public boolean isGreaterThan(Temperature otherT) {
    if (compareTo(otherT) > 0) {
      return true;
    }
    return false;
  }

  public boolean isLessThan(Temperature otherT) {
    if (compareTo(otherT) < 0) {
      return true;
    }
    return false;
  }

  // utilities methods
  public String toString() {
    return value + " degree " + type;
  }
  // check whether the type is valid
  private static boolean checkType(char type) {
    if ( (type == CELSIUS) || (type == FAHRENHEIT)) {
      return true;
    }
    return false;
  }

  // round a double to nearest tenth of a degree
  private static double round(double value) {
    long temp = Math.round(value * 10);
    return temp / 10.0;
  }

}
