public class Problem2 {

    // Class variables (visible to all methods in Problem1):
    public static final int MAX = 1000;    
    public static final int MIN = -1000;    
    
    
    //*********************************************************************
    // Start program: 
    // set param values and then perform both numerical techniques:
    //*********************************************************************
    public static void main(String[] args) {
	welcome();
	process();
    } // Method main


    //*********************************************************************
    // Welcome to user in a cheery fashion:
    //*********************************************************************
    public static void welcome() {
	System.out.println("+-------------------------------------------------------------+\n" +
			   "| Welcome to the number guessing program!                     |\n" +
			   "| Guess the random number that JAVA picked withing a          |\n" +
			   "| range that you will enter. Enter only integers!             |\n" +
			   "| To interrupt the game, enter a value 1 higher/lower than    |\n" +	
			   "| the range that you selected.                                |\n" +
			   "+-------------------------------------------------------------+");
    } // Method welcome
        
        
        
    //*********************************************************************
    // Prompt user for game until finished:
    //*********************************************************************
    public static void process() {
	boolean stop = false;

	while (!stop) {
	    int low = readInt(MIN, MAX, "Enter the lowest value between " + MIN + " and " + MAX +": ");
	    int high = readInt(low, MAX, "Enter the highest value between " + low + " and " + MAX + ": ");
	    
	    numberGuessing(low, high);
	    
	    boolean done = false;

	    while (!done){
	    	System.out.print("Do you want to repeat the game? [Y, N]:");
	    	String sol = SavitchIn.readLine();
	    	sol = sol.toUpperCase();
	    	done = true; 
	    	
	    	if (sol.equals("Y")){
			stop = false;
	    	}
	    	else if(sol.equals("N")){
			stop = true;
		}
	    	else{
			System.out.println("What?");
			done = false;
		}
	    }
	    
	}

	System.out.println("+-------------------------------------------------------------+\n"+
			   "| Done! Thanks for playing!                                   |\n"+
			   "+-------------------------------------------------------------+");
    } // Method process    
    


    public static int readInt(int low, int high, String prompt){
    	boolean done = false;
    	int input = 0;

	System.out.print(prompt);    	
    	while (!done){
    		input = SavitchIn.readLineInt();	
    		done = true;
    		
    		if (input < low || input > high){
    			System.out.print("  That value is not legal! Please re-enter: ");
    			done = false;	
    		}
    	}
    	
    	return input;
    }
    
    public static int randInt(int low, int high){
    	return (int) (Math.random() * (high - low + 1))	+ (int) low;
    }
    
    public static void numberGuessing(int low, int high){
    	int target = randInt(low, high);
    	
    	int guess = readInt(low - 1, high + 1, "Guess a number between " + low + " and " + high + ": ");
    	int count = 1;
    	while ( guess != target && guess <= high && guess >= low && count <= high - low){
    		count++;
    		
    		if (guess < target){
    			System.out.println( "  " + guess + " is too low!");	
    		} else if (guess > target) {
    			System.out.println( "  " + guess + " is too high!");	
    		}
    		
    		guess = readInt(low - 1, high + 1, "Guess another number: ");
    	}

	if (guess == target) {
		System.out.println("  Congratulation! " + guess + " is the right answer. ");	
		System.out.println("  You took " + count + " guess(es).");	
	}    	
	else if (guess > high || guess < low) {
		System.out.println("  Halting!");
		System.out.println("  The correct guess was " + target + ".");
	}
	else if (count > high - low){
		System.out.println("  You were taking too long...!");	
		System.out.println("  The correct guess was " + target + ".");
	} 
	else {
		System.out.println("  Something horrible happend. Fix the program!");	
	}
	
    }

}