/* Template for Problem1
 *
 * Students need to supply the bodies of the methods that we indicate in this file 
 * and submit the ENTIRE, completed version.
 * 
 * The following empty methods are known as STUBS, which are
 * method/class headers with no bodies. By working on each method
 * individually, you can develop and test each method to build your
 * program instead of trying to do it all at once.
 */

public class Problem1 {

    // Class variables (visible to all methods in Problem1):
    public static final double EPS = 0.001;     // tolerance
    public static final double MAXITERS = 1000; // max iterations allowed
    public static final double TARGET = 0;      // target value of pile depth equation
    public static double gamma;                 // kN/m^3, unit weight of soil
    public static double phi;                   // 30deg, measure of soil friction
    public static double length;                // m, height of pile above ground cut
    public static double force;                 // kN/m, force that soil exerts on pile, per unit m

    //*********************************************************************
    // Start program: 
    // set param values and then perform both numerical techniques:
    //*********************************************************************
    public static void main(String[] args) {

	welcome();
	setParams();
	process();

    } // Method main

    //*********************************************************************
    // Welcome to user in a cheery fashion:
    //*********************************************************************
    public static void welcome() {

	System.out.println("Welcome to A4!");

    } // Method welcome


    //*********************************************************************
    // Parameters used by pile depth equation:
    //*********************************************************************
    public static void setParams() {

	gamma  = 18.0;      
	phi    = Math.PI/6;
	length = 3.0;      
	force  = 30;       
	// a better approach would be using file I/O

    } // Method setParams


    //*********************************************************************
    // Prompt user for technique until finished:
    //*********************************************************************
    public static void process() {

	boolean stop = false;
	while (!stop) {
	    System.out.print("Which technique do you want? [(L)HSRHS,(B)isection,(Q)uit]: ");
	    String sol = SavitchIn.readLine();
	    sol = sol.toUpperCase();
	    if (sol.equals("L") || sol.equals("B"))
		solveEqn(sol);
	    else if(sol.equals("Q"))
		stop = true;
	    else
		System.out.println("What?");
	}

	System.out.println("Good-bye!");

    } // Method process

    //*********************************************************************
    // Solve pile depth equation with a particular technique:
    //*********************************************************************
    public static void solveEqn(String s) {

	double depth = -1;  // solution so far
	
	if (s.equals("L")) {
	    s = "LHSRHS";
	    depth = lhsrhs();
	} else if (s.equals("B")) {
	    s = "BISECTION";
	    depth = bisection();
	} else {
	    System.out.println("Fatal error code 13-7. Aborting!"); 
	    System.exit(0); 
	}

	if (depth <= 0)
	    System.out.println("No solution for "+s+" .");
	else {
	    System.out.println(s+": "+depth);
	    System.out.println("EQN: "+evalPileDepthEqn(depth));
	}


    } // Method solveEqn


    //*********************************************************************
    // LHSRHS Method: return the root of the pile depth equation:
    //*********************************************************************
    public static double lhsrhs() {
	double depth = -1;           // pile depth so far
	double initguess = depth;    // initial guess of depth
	double eqn;                  // value of pile depth equation so far
	int oldsign;                 // current sign of equation

	int dir = 0;                 // iteration direction so far
	final int LEFT = -1;         // direction to the left
	final int RIGHT = 1;         // direction to the right

	final double FACTOR = 10;    // amount to divide increment
	final double INITINC = 0.01; // starting value of all increments
	double inc = INITINC;        // increment so far
	int iters = 0;               // number of iterations so far
    
	// Set up initial depth, direction, and test values:
  	   System.out.println("Now using LHSRHS!");

	   do {
	       System.out.print("Enter your initial guess for pile depth: ");
	       depth = SavitchIn.readLineDouble();
	       if (depth <= 0) System.out.println("Make it postive!");
	   } while(depth <= 0);
	   
	   do {
	       System.out.print("Enter your initial direction for iteration [-1,1]: ");
	       dir = SavitchIn.readLineInt();
	       if (dir != RIGHT && dir != LEFT) System.out.println("Make it 1 or -1!");
	   } while(dir != RIGHT && dir != LEFT);
	   
	   initguess = depth;
	   eqn = evalPileDepthEqn(depth);
	   oldsign = sign(eqn);
	   
	// Search root; equation must not be satisfied or iterations not exhausted:
    	   while ( iters <= MAXITERS && Math.abs(eqn-TARGET) > EPS ) {

	       // guess was bad! update count of guesses:
	          iters += 1;

	       // prepare for next guess:
		  depth += dir*inc;
		  eqn = evalPileDepthEqn(depth);
		  int newsign = sign(eqn);
		  
  	       // if sign changes, root was missed! go backwards now:
		  if (newsign != oldsign) {
		      dir *= -1;          // change direciton
		      inc /= FACTOR;      // refine increment
		      oldsign = newsign;  // update sign
		      iters = 0;          // reset iters
		  }
		  
	       // if reach "y-axis", went too far to the left! reverse direction:
		  if (depth < EPS) {
		      depth = EPS;                   // reset depth
		      eqn = evalPileDepthEqn(depth); // new starting point
		      oldsign = sign(eqn);           // need to know new sign for next iteration
		      dir = RIGHT;                   // iterate to the right
		      inc = INITINC; 		     // reset increment
		  }


	   } // end while
	   
	   // Send back either -1 or the actual found depth:
	      if (iters > MAXITERS)
		  return -1;
	      else
		  return depth;
	      
    } // Method lhsrhs

    //*********************************************************************    
    // Return the sign of x...zero values are considered as positive:
    //*********************************************************************
    public static int sign(double x) {
	return x >= 0 ? 1 : -1;
    }

    //*********************************************************************    
    // Bisection Method: return the  root of the pile depth equation:
    //*********************************************************************
    public static double bisection() {
	double left = -1;      // initial guess of left
	double mid = -1;       // mid point so far
	double right = -1;     // initial guess of right
	double eqnL;           // equation at left
	double eqnM;           // equation at mid
	double eqnR;           // equation at right
	int iters = 0;         // number of iterations so far
    
	// Set up initial depth, direction, and test values:
  	   System.out.println("Now using Bisection!");

	   do {
	       System.out.print("Enter your initial guess for the left depth: ");
	       left = SavitchIn.readLineDouble();
	       if (left <= 0) System.out.println("Make it positive!");
	   } while(left <= 0);

	   do {
	       System.out.print("Enter your initial guess for the right depth: ");
	       right = SavitchIn.readLineDouble();
	       if (right < left) System.out.println("Make it at least as big as the left depth!");
	   } while(right < left);

	   mid = (left+right)/2.0;
	   eqnM = evalPileDepthEqn(mid);
	   
	// Search root; equation must not be satisfied or iterations not exhausted:
    	   while ( iters <= MAXITERS && Math.abs(eqnM-TARGET) > EPS ) {

	       // Get left, right and mid values
	          eqnL  = evalPileDepthEqn(left);
		  eqnR  = evalPileDepthEqn(right);

	       // mid is to the left of root:
		  if (eqnM * eqnR <= 0)
		      left = mid;
		  else if (eqnM * eqnR >= 0)
		      right = mid;
		  
	       // update data:
		  iters += 1;
		  mid = (left+right)/2.0;
		  eqnM = evalPileDepthEqn(mid);
	   }

	   // Send back either -1 or the actual found depth:
	      if (iters > MAXITERS)
		  return -1;
	      else
		  return mid;

    } // Method bisection

    //*********************************************************************
    // Return the value of the pile depth equation
    // Requires supplied depth and previously set params
    //*********************************************************************
    public static double evalPileDepthEqn(double d) {

	double Ka = Math.pow(Math.tan(Math.PI/4 - phi/2),2);
        double Kp = Math.pow(Math.tan(Math.PI/4 + phi/2),2);

	double a4 = 1;
	double a3 = 0;
	double a2 = -8*force/(gamma*(Kp-Ka));
	double a1 = -12*force*length/(gamma*(Kp-Ka));
	double a0 = -1 * Math.pow( (2*force/(gamma*(Kp-Ka))), 2);
	
	return a4*Math.pow(d,4) + a3*Math.pow(d,3) + a2*Math.pow(d,2) + a1*d + a0;

    } // Method evalPileDepthEqn
     
} // Class Problem1
