%=============================================================================%
% Newton's Method                                                             %
%=============================================================================%
% Approach:
% ....
%=============================================================================%
% Refresh the workspace                                                       %
%=============================================================================%
  clear
  clc
  disp('Starting newton method...');
%=============================================================================%
% Initial Guess                                                               %
%=============================================================================%
% User must enter a positive number
  d = input('Enter your guess for pile depth [positive]: ');
  while( ~isnumeric(d) | d <= 0 )
     d = input('No! You must enter a positive number: ');
  end

%------------------------------------------------------------------------------
% get Params
  [Gamma, phi, L, P, eps, max_iterations] = getParams;
  
%=============================================================================%
% Initial Data                                                                %
%=============================================================================%
  target     = 0;      % stopping value
  iterations = 0;      % number of iterations to find root

% Find initial function value
  eqn = evalPileDepthEqn(phi,Gamma,P,L,d);
  
%=============================================================================%
% Iterate for pile depth                                                      %
%=============================================================================%
% could also use delta = -eqn/deriv to stop
  while ( abs(eqn-target) > eps && iterations <= max_iterations)

     deriv = evalPileDepthEqnDeriv(phi,Gamma,P,L,d);
     d     = d - eqn/deriv;
     eqn   = evalPileDepthEqn(phi,Gamma,P,L,d);

     % increment count of iterations
       iterations = iterations + 1;

  end
  
%=============================================================================%
% Report or repeat                                                            %
%=============================================================================%
 if iterations > max_iterations
     n=0;y=1; % so user can actually enter the letters n and y
     choice = input('taking too long -- try another starting value for newton method? [y,n]: ');
     while( ~(choice==0 | choice==1) )
        choice = input('I asked, "Do you want to try another starting value for newton method? [y,n]:"! ');
     end
     if (choice == y)
         clear
         newtonsmethod
         return 
     end
 else
    iterations 
    d
    eqn
    if d < 0
        n=0;y=1; % so user can actually enter the letters n and y
        choice = input('root is less than 0 -- try another starting value for newton method? [y,n]: ');
        while( ~(choice==0 | choice==1) )
            choice = input('I asked, "Do you want to try another starting value for newton method? [y,n]:"! ');
        end
        if (choice == y)
            clear
            newtonsmethod
            return 
        end
    end
 end
 

%------------------------------------------------------------------------------
% Flag user when done
  disp('Finished newtons method! press any key to continue...')
  clear
  pause

% Problem: if pick starting value too close to zero, will get zero
% For bonus -- fix!

