%------------------------------------------------------------------------------
% Script for finding sheetpile depth manually
% + Use a plot and then visually inspect the results
% + This approach only works for a handful of cases, because multiple cases
%   would take too long.
% Approach:
% + Refresh worksheet
% + Collect data
% + Guess a range of value of D
% + Plot the piledepth equation for each D
% + Visually inspect the plot to find an interval that contains D
%------------------------------------------------------------------------------
% Refresh the workspace
  clear 
  clc
  disp(['Manual method....']);

%------------------------------------------------------------------------------
% get Params
  [Gamma, phi, L, P] = getParams;
  
%------------------------------------------------------------------------------
% Initial guesses
% ===============
% Get initial guess of lowD
% User must enter a positive number
  lowD = input('Enter the lower bound of the plotting interval [positive]: ');
  while( ~isnumeric(lowD) | lowD < 0 )
     lowD = input('No! You must enter a positive number: ');
  end
% Get initial guess of newD
% User must enter a positive number
  newD = input('Enter the upper bound of the plotting interval [positive]: ');
  while( ~isnumeric(newD) | newD < lowD )
     newD = input('No! You must enter a positive number greater than "left": ');
  end

%------------------------------------------------------------------------------
% Plot values for each guess
% Could automate this further by letting program decrement D starting
% from initial guess

% Plot range of D
  pdplot(phi,Gamma,P,L,lowD:(newD-lowD)/100:newD)
   
% Ask user to continue
  n=0;y=1; % so user can actually enter the letters n and y
  choice = input('Do you want to try another plotting interval? [y,n]: ');
  while( ~(choice==0 | choice==1) )
     choice = input('I asked, "Do you want to try another plotting interval? [y,n]:"! ');
  end
 
% Stop guessing if 1, otherwise continue
  if (choice == y)
     clear
     manualmethod
     return
 end
 
 %------------------------------------------------------------------------------
 % Flag user when done
  disp('Finished manual method! press any key to continue...')
  clear
  pause
 